/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.editor.AnnotationStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultColors {
    private static final float BRIGHT = 0.95f;
    public static final Color[] COLORS = new Color[]{Color.getHSBColor(0.15277778f, 0.25f, 0.95f), Color.getHSBColor(0.0f, 0.25f, 0.95f), Color.getHSBColor(0.5833333f, 0.25f, 0.95f), Color.getHSBColor(0.33333334f, 0.25f, 0.95f), Color.getHSBColor(0.8055556f, 0.25f, 0.95f), Color.getHSBColor(0.083333336f, 0.25f, 0.95f), Color.getHSBColor(0.22222222f, 0.25f, 0.95f), Color.getHSBColor(0.9166667f, 0.25f, 0.95f), Color.getHSBColor(0.44444445f, 0.25f, 0.95f), Color.getHSBColor(0.6944444f, 0.25f, 0.95f), Color.getHSBColor(0.15277778f, 0.5f, 0.95f), Color.getHSBColor(0.0f, 0.5f, 0.95f), Color.getHSBColor(0.5833333f, 0.5f, 0.95f), Color.getHSBColor(0.33333334f, 0.5f, 0.95f), Color.getHSBColor(0.8055556f, 0.5f, 0.95f), Color.getHSBColor(0.083333336f, 0.5f, 0.95f), Color.getHSBColor(0.22222222f, 0.5f, 0.95f), Color.getHSBColor(0.9166667f, 0.5f, 0.95f), Color.getHSBColor(0.44444445f, 0.5f, 0.95f), Color.getHSBColor(0.6944444f, 0.5f, 0.95f), Color.getHSBColor(0.15277778f, 0.75f, 0.95f), Color.getHSBColor(0.0f, 0.75f, 0.95f), Color.getHSBColor(0.5833333f, 0.75f, 0.95f), Color.getHSBColor(0.33333334f, 0.75f, 0.95f), Color.getHSBColor(0.8055556f, 0.75f, 0.95f), Color.getHSBColor(0.083333336f, 0.75f, 0.95f), Color.getHSBColor(0.22222222f, 0.75f, 0.95f), Color.getHSBColor(0.9166667f, 0.75f, 0.95f), Color.getHSBColor(0.44444445f, 0.75f, 0.95f), Color.getHSBColor(0.6944444f, 0.75f, 0.95f)};

    public static Collection<AnnotationStyle> assignColors(TypeSystem ts, Collection<AnnotationStyle> styles) {
        HashMap<String, Color> typeNameToColorMap = new HashMap<String, Color>();
        for (AnnotationStyle style : styles) {
            typeNameToColorMap.put(style.getAnnotation(), style.getColor());
        }
        for (Type type : ts.getProperlySubsumedTypes(ts.getType("uima.tcas.Annotation"))) {
            if (typeNameToColorMap.containsKey(type.getName())) continue;
            Color color = COLORS[typeNameToColorMap.size() % COLORS.length];
            typeNameToColorMap.put(type.getName(), color);
        }
        HashSet<AnnotationStyle> newStyles = new HashSet<AnnotationStyle>();
        for (AnnotationStyle annotationStyle : styles) {
            typeNameToColorMap.remove(annotationStyle.getAnnotation());
            newStyles.add(annotationStyle);
        }
        for (Map.Entry entry : typeNameToColorMap.entrySet()) {
            newStyles.add(new AnnotationStyle((String)entry.getKey(), AnnotationStyle.Style.BACKGROUND, (Color)entry.getValue(), 0));
        }
        return Collections.unmodifiableSet(newStyles);
    }
}

