/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.uima;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.caseditor.core.model.CorpusElement;
import org.apache.uima.caseditor.core.model.DocumentElement;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.collection.impl.CasConverter;
import org.apache.uima.util.Progress;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorporaCollectionReader
extends CollectionReader_ImplBase {
    private Iterator<DocumentElement> documentIterator;

    public void setCorpora(Collection<CorpusElement> corpora) {
        if (corpora != null) {
            LinkedList<DocumentElement> documents = new LinkedList<DocumentElement>();
            for (CorpusElement element : corpora) {
                documents.addAll(element.getDocuments());
            }
            this.documentIterator = documents.iterator();
        }
    }

    public void getNext(CAS cas) throws CollectionException {
        DocumentElement document = this.documentIterator.next();
        CAS documentCas = null;
        try {
            documentCas = document.getDocument(false).getCAS();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        CasConverter converter = new CasConverter();
        CasData documentData = converter.casContainerToCasData(documentCas);
        converter.casDataToCasContainer(documentData, cas, true);
    }

    public boolean hasNext() {
        if (this.documentIterator != null) {
            return this.documentIterator.hasNext();
        }
        return false;
    }

    public Progress[] getProgress() {
        return new Progress[0];
    }

    public void close() {
    }
}

