/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.wizards;

import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.ui.wizards.NewNlpProjectWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public final class NewNlpProjectWizard
extends Wizard
implements INewWizard {
    public static final String ID = "org.apache.uima.caseditor.wizards.NLPProjectWizard";
    private NewNlpProjectWizardPage mMainPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New Cas Editor Project");
    }

    public void addPages() {
        this.mMainPage = new NewNlpProjectWizardPage();
        this.mMainPage.setTitle("Create a Cas Editor Project");
        this.mMainPage.setDescription("Create a Cas Editor Project in the workspace");
        this.addPage((IWizardPage)this.mMainPage);
    }

    public boolean performFinish() {
        IProject newNLPProject = this.mMainPage.getProjectHandle();
        NewNlpProjectWizard.createProject(newNLPProject, this.mMainPage.getLocationPath());
        try {
            NlpProject.addNLPNature(newNLPProject);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void createProject(IProject project, IPath location) {
        if (!project.exists()) {
            IProjectDescription projectDescribtion = project.getWorkspace().newProjectDescription(project.getName());
            if (Platform.getLocation().equals(location)) {
                location = null;
            }
            projectDescribtion.setLocation(location);
            try {
                project.create(projectDescribtion, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (!project.isOpen()) {
            try {
                project.open(null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

