/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.ui.wizards.DocumentImportStructureProvider;
import org.apache.uima.caseditor.ui.wizards.ImportDocumentWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public final class ImportDocumentWizard
extends Wizard
implements IImportWizard {
    private ImportDocumentWizardPage mMainPage;
    private IStructuredSelection mCurrentResourceSelection;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mCurrentResourceSelection = selection;
        this.setWindowTitle("Import");
    }

    public void addPages() {
        this.mMainPage = new ImportDocumentWizardPage("ImportDocuments", this.mCurrentResourceSelection);
        this.addPage((IWizardPage)this.mMainPage);
    }

    public boolean performFinish() {
        DocumentImportStructureProvider importProvider = new DocumentImportStructureProvider(this.mMainPage.getTextEncoding(), this.mMainPage.getCasFormat());
        ImportOperation operation = new ImportOperation(this.mMainPage.getImportDestinationPath(), (IImportStructureProvider)importProvider, null, this.mMainPage.getFilesToImport());
        operation.setContext(this.getShell());
        operation.setOverwriteResources(false);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            CasEditorPlugin.log(e);
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)"Error during import", (String)e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }
}

