/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.caseditor.core.TaeError;
import org.apache.uima.caseditor.editor.DocumentFormat;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DocumentImportStructureProvider
implements IImportStructureProvider {
    private final String importEncoding;
    private final DocumentFormat casFormat;

    public DocumentImportStructureProvider(String importEncoding, DocumentFormat casFormat) {
        this.importEncoding = importEncoding;
        this.casFormat = casFormat;
    }

    public List<Object> getChildren(Object element) {
        return null;
    }

    private static CAS createEmtpyCAS() {
        TypeSystemDescription typeSystemDesciptor;
        XMLInputSource xmlTypeSystemSource = new XMLInputSource(DocumentImportStructureProvider.class.getResourceAsStream("ts.xml"), new File(""));
        XMLParser xmlParser = UIMAFramework.getXMLParser();
        try {
            typeSystemDesciptor = (TypeSystemDescription)xmlParser.parse(xmlTypeSystemSource);
        }
        catch (InvalidXMLException e1) {
            throw new TaeError("Integrated ts.xml typesystem descriptor is not valid!");
        }
        try {
            return CasCreationUtils.createCas((TypeSystemDescription)typeSystemDesciptor, null, null);
        }
        catch (ResourceInitializationException e) {
            throw new TaeError("Unexpected exception!");
        }
    }

    private InputStream getDocument(String text, DocumentFormat format) {
        CAS cas = DocumentImportStructureProvider.createEmtpyCAS();
        cas.setDocumentText(text);
        ByteArrayOutputStream out = new ByteArrayOutputStream(40000);
        if (DocumentFormat.XCAS.equals((Object)format)) {
            try {
                XCASSerializer.serialize((CAS)cas, (OutputStream)out);
            }
            catch (SAXException e) {
                throw new TaeError("Unexpected exception!", e);
            }
            catch (IOException e) {
                throw new TaeError("Unexpected exception!", e);
            }
        } else if (DocumentFormat.XMI.equals((Object)format)) {
            try {
                XmiCasSerializer.serialize((CAS)cas, (OutputStream)out);
            }
            catch (SAXException e) {
                throw new TaeError("Unexpected exception!", e);
            }
        } else {
            throw new TaeError("Unkown document type!", null);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContents(Object element) {
        File fileToImport = (File)element;
        String fileName = fileToImport.getName();
        if (fileName.endsWith(".rtf")) {
            FileInputStream in = null;
            try {
                in = new FileInputStream((File)element);
                String text = this.convert(in);
                InputStream inputStream = this.getDocument(text, this.casFormat);
                return inputStream;
            }
            catch (FileNotFoundException e) {
                InputStream inputStream = null;
                return inputStream;
            }
            catch (IOException e) {
                InputStream inputStream = null;
                return inputStream;
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException e) {}
            }
        }
        if (fileName.endsWith(".txt")) {
            FileInputStream in = null;
            try {
                in = new FileInputStream((File)element);
                StringBuilder textStringBuffer = new StringBuilder();
                byte[] readBuffer = new byte[2048];
                while (((InputStream)in).available() > 0) {
                    int length = ((InputStream)in).read(readBuffer);
                    textStringBuffer.append(new String(readBuffer, 0, length, this.importEncoding));
                }
                InputStream length = this.getDocument(textStringBuffer.toString(), this.casFormat);
                return length;
            }
            catch (FileNotFoundException e) {
                InputStream inputStream = null;
                return inputStream;
            }
            catch (IOException e) {
                InputStream inputStream = null;
                return inputStream;
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        try {
            return new FileInputStream((File)element);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private String convert(InputStream rtfDocumentInputStream) throws IOException {
        String textDocument;
        RTFEditorKit aRtfEditorkit = new RTFEditorKit();
        DefaultStyledDocument styledDoc = new DefaultStyledDocument();
        try {
            aRtfEditorkit.read(rtfDocumentInputStream, (Document)styledDoc, 0);
            textDocument = styledDoc.getText(0, styledDoc.getLength());
        }
        catch (BadLocationException e) {
            throw new IOException("Error during parsing");
        }
        return textDocument;
    }

    public String getFullPath(Object element) {
        return "";
    }

    public String getLabel(Object element) {
        File fileToImport = (File)element;
        String fileName = fileToImport.getName();
        if (fileName.endsWith(".rtf") || fileName.endsWith(".txt")) {
            String ending;
            int nameWithouEndingLength = fileName.lastIndexOf(".");
            String nameWithouEnding = fileName.substring(0, nameWithouEndingLength);
            if (DocumentFormat.XMI.equals((Object)this.casFormat)) {
                ending = "xmi";
            } else if (DocumentFormat.XCAS.equals((Object)this.casFormat)) {
                ending = "xcas";
            } else {
                throw new IllegalStateException("Unkown DocumentFormat!");
            }
            return nameWithouEnding + "." + ending;
        }
        return fileName;
    }

    public boolean isFolder(Object element) {
        return ((File)element).isDirectory();
    }
}

