/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.property;

import java.io.IOException;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.ui.property.DotCorpusPreferenceStore;
import org.apache.uima.caseditor.ui.property.FileFieldEditor;
import org.apache.uima.caseditor.ui.property.FolderPathEditor;
import org.apache.uima.caseditor.ui.property.NlpProjectFieldEditorPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ProjectPropertyPage
extends NlpProjectFieldEditorPage {
    private DotCorpusPreferenceStore mDotCorpusPropertyStore;
    private FileFieldEditor mTypeSystemFile;
    private FolderPathEditor mCasProcessorFolders;
    private FolderPathEditor mCorpusFolders;
    private IntegerFieldEditor mEditorLineLengthHint;

    public ProjectPropertyPage() {
        super(1);
    }

    protected void createFieldEditors() {
        NlpProject nlpProject = ((INlpElement)this.getElement()).getNlpProject();
        this.mDotCorpusPropertyStore = new DotCorpusPreferenceStore(nlpProject.getDotCorpus());
        Composite parent = this.getFieldEditorParent();
        this.mCasProcessorFolders = new FolderPathEditor(DotCorpusPreferenceStore.Key.TAGGER_CONFIG_FOLDER.name(), "Processor Folders", "Processor folder selection", "Select the processor folder", parent, nlpProject);
        this.mCasProcessorFolders.setPreferenceStore((IPreferenceStore)this.mDotCorpusPropertyStore);
        this.addField((FieldEditor)this.mCasProcessorFolders);
        this.mCorpusFolders = new FolderPathEditor(DotCorpusPreferenceStore.Key.CORPUS_FOLDERS.name(), "Corpus Folders", "Corpus folder selection", "Select the corpus folder", parent, nlpProject);
        this.mCorpusFolders.setPreferenceStore((IPreferenceStore)this.mDotCorpusPropertyStore);
        this.addField((FieldEditor)this.mCorpusFolders);
        this.mTypeSystemFile = new FileFieldEditor(DotCorpusPreferenceStore.Key.TYPE_SYSTEM_FILE.name(), "Typesystem", "Typesystem file selection", "Select the typesystem file", parent, nlpProject);
        this.mTypeSystemFile.setChangeButtonText("Browse...");
        this.mTypeSystemFile.setPreferenceStore((IPreferenceStore)this.mDotCorpusPropertyStore);
        this.addField((FieldEditor)this.mTypeSystemFile);
        this.mEditorLineLengthHint = new IntegerFieldEditor(DotCorpusPreferenceStore.Key.EDITOR_LINE_LENGTH_HINT.name(), "Line Length Hint", parent);
        this.mEditorLineLengthHint.setPreferenceStore((IPreferenceStore)this.mDotCorpusPropertyStore);
        this.addField((FieldEditor)this.mEditorLineLengthHint);
    }

    public boolean performOk() {
        this.mTypeSystemFile.store();
        this.mCorpusFolders.store();
        this.mCasProcessorFolders.store();
        this.mEditorLineLengthHint.store();
        try {
            this.mDotCorpusPropertyStore.save();
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to save settings!", (String)("Unable to save settings:" + e.getMessage()));
            return false;
        }
        return true;
    }

    protected void performDefaults() {
        this.mTypeSystemFile.loadDefault();
        this.mCorpusFolders.loadDefault();
        this.mCasProcessorFolders.loadDefault();
        this.mEditorLineLengthHint.loadDefault();
    }
}

