/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.property;

import java.util.Collection;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.DotCorpusElement;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.model.TypesystemElement;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.apache.uima.caseditor.ui.property.AnnotationPropertyPage;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NlpAnnotationPropertyPage
extends AnnotationPropertyPage {
    private NlpProject mProject;
    private DotCorpusElement mDotCorpusElement;

    @Override
    protected AnnotationStyle getAnnotationStyle(Type type) {
        return this.mDotCorpusElement.getAnnotation(type);
    }

    @Override
    protected TypeSystem getTypeSystem() {
        this.mProject = ((INlpElement)this.getElement()).getNlpProject();
        this.mDotCorpusElement = this.mProject.getDotCorpus();
        TypesystemElement tsElement = this.mProject.getTypesystemElement();
        if (tsElement != null) {
            return tsElement.getTypeSystem();
        }
        return null;
    }

    @Override
    protected boolean saveChanges(Collection<AnnotationStyle> changedStyles) {
        for (AnnotationStyle style : changedStyles) {
            this.mDotCorpusElement.setStyle(style);
        }
        if (this.mProject.getTypesystemElement() == null || this.mProject.getTypesystemElement().getTypeSystem() == null) {
            return true;
        }
        try {
            this.mDotCorpusElement.serialize();
        }
        catch (CoreException e) {
            CasEditorPlugin.log(e);
            return false;
        }
        AnnotationEditor[] editors = AnnotationEditor.getAnnotationEditors();
        if (editors.length > 0) {
            editors[0].getDocumentProvider().fireAnnotationStyleChanged(editors[0].getEditorInput(), changedStyles);
        }
        return true;
    }
}

