/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.property;

import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.ui.property.FolderElementFilter;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class FolderPathEditor
extends PathEditor {
    private NlpProject mProject;
    private final String title;
    private final String message;

    FolderPathEditor(String name, String label, String title, String message, Composite parent, NlpProject project) {
        super(name, label, name, parent);
        this.title = title;
        this.message = message;
        this.mProject = project;
    }

    protected String getNewInputObject() {
        ElementTreeSelectionDialog folderSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        folderSelectionDialog.addFilter((ViewerFilter)new FolderElementFilter());
        folderSelectionDialog.setInput((Object)this.mProject);
        folderSelectionDialog.setTitle(this.title);
        folderSelectionDialog.setMessage(this.message);
        folderSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && selection[0] instanceof IFolder) {
                    return new Status(0, "org.apache.uima.caseditor", 0, "", null);
                }
                return new Status(4, "org.apache.uima.caseditor", 0, "Please select a folder!", null);
            }
        });
        folderSelectionDialog.open();
        Object[] results = folderSelectionDialog.getResult();
        if (results != null) {
            return ((IFolder)results[0]).getFullPath().removeFirstSegments(1).toString();
        }
        return null;
    }
}

