/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.property;

import org.apache.uima.caseditor.core.model.NlpProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class FolderFieldEditor
extends StringButtonFieldEditor {
    private NlpProject mProject;

    FolderFieldEditor(String name, String labelText, Composite parent, NlpProject project) {
        super(name, labelText, parent);
        this.mProject = project;
    }

    protected String changePressed() {
        ElementTreeSelectionDialog folderSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        folderSelectionDialog.setInput((Object)this.mProject);
        folderSelectionDialog.setTitle(this.getLabelText());
        folderSelectionDialog.setMessage(this.getPreferenceName());
        folderSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && selection[0] instanceof IFolder) {
                    return new Status(0, "org.apache.uima.caseditor", 0, "", null);
                }
                return new Status(4, "org.apache.uima.caseditor", 0, "Please select a folder!", null);
            }
        });
        folderSelectionDialog.open();
        Object[] results = folderSelectionDialog.getResult();
        if (results.length != 1) {
            return null;
        }
        return ((IFolder)results[0]).getFullPath().removeFirstSegments(1).toString();
    }
}

