/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.property;

import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.ui.property.FileElementFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class FileFieldEditor
extends StringButtonFieldEditor {
    private NlpProject mProject;
    private String title;
    private String message;

    FileFieldEditor(String name, String label, String title, String message, Composite parent, NlpProject project) {
        super(name, label, parent);
        this.title = title;
        this.message = message;
        this.mProject = project;
    }

    protected String changePressed() {
        ElementTreeSelectionDialog fileSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        fileSelectionDialog.addFilter((ViewerFilter)new FileElementFilter());
        fileSelectionDialog.setInput((Object)this.mProject);
        fileSelectionDialog.setTitle(this.title);
        fileSelectionDialog.setMessage(this.message);
        fileSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && selection[0] instanceof IFile) {
                    return new Status(0, "org.apache.uima.caseditor", 0, "", null);
                }
                return new Status(4, "org.apache.uima.caseditor", 0, "Please select a file!", null);
            }
        });
        fileSelectionDialog.open();
        Object[] results = fileSelectionDialog.getResult();
        if (results != null) {
            return ((IFile)results[0]).getFullPath().removeFirstSegments(1).toString();
        }
        return null;
    }
}

