/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.property;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.uima.caseditor.core.model.DotCorpusElement;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;

public class DotCorpusPreferenceStore
implements IPersistentPreferenceStore {
    private DotCorpusElement mDotCorpusElement;

    public DotCorpusPreferenceStore(DotCorpusElement dotCorpusElement) {
        this.mDotCorpusElement = dotCorpusElement;
    }

    public boolean needsSaving() {
        return false;
    }

    public void save() throws IOException {
        try {
            this.mDotCorpusElement.serialize();
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
    }

    public boolean contains(String name) {
        return false;
    }

    public boolean isDefault(String name) {
        return false;
    }

    public void setToDefault(String name) {
    }

    public boolean getDefaultBoolean(String name) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public void setDefault(String name, boolean value) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public boolean getBoolean(String name) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public void setValue(String name, boolean value) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public int getDefaultInt(String name) {
        return this.getInt(name);
    }

    public void setDefault(String name, int value) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public int getInt(String name) {
        if (Key.EDITOR_LINE_LENGTH_HINT.equals((Object)Key.valueOf(name))) {
            return this.mDotCorpusElement.getEditorLineLengthHint();
        }
        throw new IllegalArgumentException("Unkown name: " + name);
    }

    public void setValue(String name, int value) {
        if (!Key.EDITOR_LINE_LENGTH_HINT.equals((Object)Key.valueOf(name))) {
            throw new IllegalArgumentException("Unkown name: " + name);
        }
        this.mDotCorpusElement.setEditorLineLengthHint(value);
    }

    public long getDefaultLong(String name) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public void setDefault(String name, long value) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public long getLong(String name) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public void setValue(String name, long value) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public float getDefaultFloat(String name) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public void setDefault(String name, float value) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public float getFloat(String name) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public void setValue(String name, float value) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public double getDefaultDouble(String name) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public void setDefault(String name, double value) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public double getDouble(String name) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public void setValue(String name, double value) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public String getDefaultString(String name) {
        return this.getString(name);
    }

    public void setDefault(String name, String defaultObject) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    public String getString(String name) {
        Key key = Key.valueOf(name);
        if (Key.TAGGER_CONFIG_FOLDER.equals((Object)key)) {
            StringBuilder pathStringBuilder = new StringBuilder();
            for (IFolder folderName : this.mDotCorpusElement.getCasProcessorFolders()) {
                pathStringBuilder.append(folderName.getName());
                pathStringBuilder.append(File.pathSeparator);
            }
            return pathStringBuilder.toString();
        }
        if (Key.TYPE_SYSTEM_FILE.equals((Object)key)) {
            return this.mDotCorpusElement.getTypeSystemFile() != null ? this.mDotCorpusElement.getTypeSystemFile().getName() : "";
        }
        if (Key.CORPUS_FOLDERS.equals((Object)key)) {
            StringBuilder pathStringBuilder = new StringBuilder();
            for (IFolder folderName : this.mDotCorpusElement.getCorpusFolderNameList()) {
                pathStringBuilder.append(folderName.getName());
                pathStringBuilder.append(File.pathSeparator);
            }
            return pathStringBuilder.toString();
        }
        throw new IllegalArgumentException("Provided key is unkown!");
    }

    public void setValue(String name, String value) {
        block7: {
            Key key;
            block8: {
                block6: {
                    key = Key.valueOf(name);
                    if (!Key.TAGGER_CONFIG_FOLDER.equals((Object)key)) break block6;
                    StringTokenizer tokenizer = new StringTokenizer(value, File.pathSeparator);
                    for (IFolder folder : this.mDotCorpusElement.getCasProcessorFolders()) {
                        this.mDotCorpusElement.removeCasProcessorFolder(folder.getName());
                    }
                    while (tokenizer.hasMoreTokens()) {
                        this.mDotCorpusElement.addCasProcessorFolder(tokenizer.nextToken());
                    }
                    break block7;
                }
                if (!Key.TYPE_SYSTEM_FILE.equals((Object)key)) break block8;
                if (value.length() != 0) {
                    this.mDotCorpusElement.setTypeSystemFilename(value);
                } else {
                    this.mDotCorpusElement.setTypeSystemFilename(null);
                }
                break block7;
            }
            if (!Key.CORPUS_FOLDERS.equals((Object)key)) break block7;
            StringTokenizer tokenizer = new StringTokenizer(value, File.pathSeparator);
            for (IFolder corpus : this.mDotCorpusElement.getCorpusFolderNameList()) {
                this.mDotCorpusElement.removeCorpusFolder(corpus);
            }
            while (tokenizer.hasMoreTokens()) {
                this.mDotCorpusElement.addCorpusFolder(tokenizer.nextToken());
            }
        }
    }

    public void putValue(String name, String value) {
        throw new IllegalArgumentException("Not expected to be used!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Key {
        TYPE_SYSTEM_FILE,
        TAGGER_CONFIG_FOLDER,
        CORPUS_FOLDERS,
        EDITOR_LINE_LENGTH_HINT;

    }
}

