/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.model;

import java.util.Collections;
import java.util.LinkedList;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.Images;
import org.apache.uima.caseditor.core.model.AbstractNlpElement;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.ui.model.AbstractElementAdapter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;

class ProjectAdapter
extends AbstractElementAdapter {
    ProjectAdapter() {
    }

    public Object[] getChildren(Object o) {
        Object[] result;
        NlpProject nlpProject = (NlpProject)o;
        if (nlpProject.getProject().isOpen()) {
            IResource[] resources;
            LinkedList<AbstractNlpElement> childrenList = new LinkedList<AbstractNlpElement>();
            childrenList.addAll(nlpProject.getCorpora());
            if (nlpProject.getTypesystemElement() != null) {
                childrenList.add(nlpProject.getTypesystemElement());
            }
            try {
                resources = nlpProject.getResources();
            }
            catch (CoreException e) {
                return new Object[0];
            }
            if (resources != null) {
                Collections.addAll(childrenList, resources);
            }
            childrenList.addAll(nlpProject.getCasProcessorFolders());
            result = childrenList.toArray();
        } else {
            result = new Object[]{};
        }
        return result;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        NlpProject nlpProject = (NlpProject)object;
        IProject project = nlpProject.getProject();
        if (project.isOpen()) {
            return CasEditorPlugin.getTaeImageDescriptor(Images.MODEL_PROJECT_OPEN);
        }
        return CasEditorPlugin.getTaeImageDescriptor(Images.MODEL_PROJECT_CLOSED);
    }
}

