/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import java.util.Iterator;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.Images;
import org.apache.uima.caseditor.ui.corpusview.CorpusExplorerUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.actions.RefreshAction;

final class WorkspaceActionGroup
extends ActionGroup {
    private OpenResourceAction mOpenProjectAction;
    private CloseResourceAction mCloseProjectAction;
    private RefreshAction mRefreshAction;
    private IAction mRetargetRefreshAction;

    WorkspaceActionGroup(Shell shell, IWorkbenchWindow window) {
        this.mOpenProjectAction = new OpenResourceAction(shell);
        this.mCloseProjectAction = new CloseResourceAction(shell);
        this.mRefreshAction = new RefreshAction(shell);
        this.mRetargetRefreshAction = ActionFactory.REFRESH.create(window);
        this.mRetargetRefreshAction.setImageDescriptor(CasEditorPlugin.getTaeImageDescriptor(Images.EXPLORER_E_REFRESH));
        this.mRetargetRefreshAction.setDisabledImageDescriptor(CasEditorPlugin.getTaeImageDescriptor(Images.EXPLORER_D_REFRESH));
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = CorpusExplorerUtil.convertNLPElementsToResources((IStructuredSelection)this.getContext().getSelection());
        boolean hasOnlyProjectSelections = true;
        boolean hasOpenProjects = false;
        boolean hasClosedProjects = false;
        boolean isEverythingKnown = false;
        Iterator resources = selection.iterator();
        while (resources.hasNext() && !isEverythingKnown) {
            isEverythingKnown = !hasOnlyProjectSelections && hasOpenProjects && hasClosedProjects;
            IResource resource = (IResource)resources.next();
            boolean isProjectSelection = resource instanceof IProject;
            if (!isProjectSelection) {
                hasOnlyProjectSelections = false;
                continue;
            }
            IProject project = (IProject)resource;
            if (project.isOpen()) {
                hasOpenProjects = true;
                continue;
            }
            hasClosedProjects = true;
        }
        if (!hasClosedProjects) {
            menu.add(this.mRetargetRefreshAction);
        }
        if (hasOnlyProjectSelections) {
            if (hasOpenProjects) {
                menu.add((IAction)this.mCloseProjectAction);
            }
            if (hasClosedProjects) {
                menu.add((IAction)this.mOpenProjectAction);
            }
            return;
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.mRefreshAction);
        actionBars.updateActionBars();
    }

    void handleKeyPressed(KeyEvent e) {
        if (e.keyCode == 0x100000E && e.stateMask == 0 && this.mRefreshAction.isEnabled()) {
            this.mRefreshAction.run();
            e.doit = false;
        }
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.mCloseProjectAction.selectionChanged(selection);
        this.mOpenProjectAction.selectionChanged(selection);
        this.mRefreshAction.selectionChanged(selection);
    }
}

