/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import java.util.LinkedList;
import org.apache.uima.caseditor.core.model.CorpusElement;
import org.apache.uima.caseditor.core.model.DocumentElement;
import org.apache.uima.caseditor.ui.action.CleanDocumentActionRunnable;
import org.apache.uima.caseditor.ui.action.RunnableAction;
import org.apache.uima.caseditor.ui.corpusview.CorpusExplorerUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionGroup;

public class UimaRefactorActionGroup
extends ActionGroup {
    private Shell shell;

    UimaRefactorActionGroup(Shell shell) {
        this.shell = shell;
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        LinkedList<DocumentElement> documentElements = new LinkedList<DocumentElement>();
        if (CorpusExplorerUtil.isContaingOnlyNlpElements(selection)) {
            for (Object resource : selection) {
                if (resource instanceof CorpusElement) {
                    documentElements.addAll(((CorpusElement)resource).getDocuments());
                }
                if (!(resource instanceof DocumentElement)) continue;
                documentElements.add((DocumentElement)resource);
            }
        }
        if (!documentElements.isEmpty()) {
            CleanDocumentActionRunnable annotatorRunnableAction = new CleanDocumentActionRunnable(documentElements);
            RunnableAction annotatorAction = new RunnableAction(this.shell, "Clean documents", annotatorRunnableAction);
            menu.add((IAction)annotatorAction);
        }
    }
}

