/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import org.apache.uima.caseditor.ui.corpusview.CopyAction;
import org.apache.uima.caseditor.ui.corpusview.CorpusExplorerUtil;
import org.apache.uima.caseditor.ui.corpusview.PasteAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;

final class RefactorGroup
extends ActionGroup {
    private Clipboard mClipboard;
    private CopyAction mCopyAction;
    private ActionFactory.IWorkbenchAction mRetargetCopyAction;
    private PasteAction mPasteAction;
    private ActionFactory.IWorkbenchAction mRetargetPasteAction;
    private DeleteResourceAction mDeleteAction;
    private ActionFactory.IWorkbenchAction mRetargetDeleteAction;
    private RenameResourceAction mRenameAction;
    private ActionFactory.IWorkbenchAction mRetargetRenameAction;

    RefactorGroup(Shell shell, IWorkbenchWindow window) {
        this.mClipboard = new Clipboard(shell.getDisplay());
        this.mCopyAction = new CopyAction(this.mClipboard);
        this.mRetargetCopyAction = ActionFactory.COPY.create(window);
        this.mPasteAction = new PasteAction(shell, this.mClipboard);
        this.mRetargetPasteAction = ActionFactory.PASTE.create(window);
        this.mDeleteAction = new DeleteResourceAction(shell);
        this.mRetargetDeleteAction = ActionFactory.DELETE.create(window);
        this.mRenameAction = new RenameResourceAction(shell);
        this.mRetargetRenameAction = ActionFactory.RENAME.create(window);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = CorpusExplorerUtil.convertNLPElementsToResources((IStructuredSelection)this.getContext().getSelection());
        boolean isAResourceSelected = !selection.isEmpty();
        menu.add((IAction)this.mRetargetCopyAction);
        menu.add((IAction)this.mRetargetPasteAction);
        if (isAResourceSelected) {
            menu.add((IAction)this.mRetargetDeleteAction);
        }
        if (selection.size() == 1) {
            menu.add((IAction)this.mRetargetRenameAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.mDeleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.mCopyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.mPasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.mRenameAction);
        actionBars.updateActionBars();
    }

    public void updateActionBars() {
        super.updateActionBars();
        IStructuredSelection selection = CorpusExplorerUtil.convertNLPElementsToResources((IStructuredSelection)this.getContext().getSelection());
        this.mCopyAction.selectionChanged(selection);
        this.mPasteAction.selectionChanged(selection);
        this.mDeleteAction.selectionChanged(selection);
        this.mRenameAction.selectionChanged(selection);
    }

    void handleKeyPressed(KeyEvent e) {
        if (e.keyCode == 0x100000B && e.stateMask == 0) {
            if (this.mRenameAction.isEnabled()) {
                this.mRenameAction.run();
                e.doit = false;
            }
        } else if (e.keyCode == 127 && e.stateMask == 0 && this.mDeleteAction.isEnabled()) {
            this.mDeleteAction.run();
            e.doit = false;
        }
    }

    public void dispose() {
        this.mClipboard.dispose();
        this.mRetargetCopyAction.dispose();
        this.mRetargetPasteAction.dispose();
        this.mRetargetDeleteAction.dispose();
        this.mRetargetRenameAction.dispose();
        super.dispose();
    }
}

