/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import java.util.List;
import org.apache.uima.caseditor.ui.corpusview.ResourceAction;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.part.ResourceTransfer;

final class PasteAction
extends ResourceAction {
    private Shell mShell;
    private Clipboard mClipboard;

    public PasteAction(Shell shell, Clipboard clipboard) {
        super("Paste");
        if (shell == null || clipboard == null) {
            throw new IllegalArgumentException();
        }
        this.mShell = shell;
        this.mClipboard = clipboard;
    }

    private IContainer getNewParent() {
        List<IResource> selection = this.getSelectedResources();
        Assert.isTrue((selection.size() > 0 ? 1 : 0) != 0);
        IContainer result = selection.get(0) instanceof IFile ? ((IFile)selection.get(0)).getParent() : (IContainer)selection.get(0);
        return result;
    }

    public void run() {
        IResource[] resourceData = (IResource[])this.mClipboard.getContents((Transfer)ResourceTransfer.getInstance());
        if (resourceData != null && resourceData.length > 0) {
            if (resourceData[0].getType() != 4) {
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.mShell);
                operation.copyResources(resourceData, this.getNewParent());
            } else {
                for (IResource element : resourceData) {
                    new CopyProjectOperation(this.mShell).copyProject((IProject)element);
                }
            }
            return;
        }
        String[] fileData = (String[])this.mClipboard.getContents((Transfer)FileTransfer.getInstance());
        if (fileData != null && fileData.length > 0) {
            new CopyFilesAndFoldersOperation(this.mShell).copyFiles(fileData, this.getNewParent());
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        IResource[] resources = (IResource[])this.mClipboard.getContents((Transfer)ResourceTransfer.getInstance());
        String[] files = (String[])this.mClipboard.getContents((Transfer)FileTransfer.getInstance());
        if (resources == null && files == null) {
            return false;
        }
        if (resources != null) {
            IProject parentProject;
            if (resources[0].getType() == 4) {
                for (IResource resource : resources) {
                    if (resource.getType() != 4 || ((IProject)resource).isOpen()) continue;
                    return false;
                }
                return true;
            }
            if (this.getSelectedNonResources().size() > 0) {
                return false;
            }
            if (this.getSelectedResources().size() != 1) {
                return false;
            }
            for (IResource resource : resources) {
                if (!resource.isLinked()) continue;
                return false;
            }
            IContainer parent = this.getNewParent();
            if (parent instanceof IProject && !(parentProject = (IProject)parent).isOpen()) {
                return false;
            }
            for (IResource resource : resources) {
                if (!resource.equals(parent)) continue;
                return false;
            }
        }
        return true;
    }
}

