/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import org.apache.uima.caseditor.ui.corpusview.CorpusExplorerUtil;
import org.apache.uima.caseditor.ui.corpusview.ICorpusExplorerActionGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;

final class OpenActionGroup
extends ActionGroup
implements ICorpusExplorerActionGroup {
    private IWorkbenchPage mPage;
    private OpenFileAction mOpenFileAction;

    OpenActionGroup(IWorkbenchPage page) {
        this.mPage = page;
        this.mOpenFileAction = new OpenFileAction(this.mPage);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = CorpusExplorerUtil.convertNLPElementsToResources((IStructuredSelection)this.getContext().getSelection());
        this.mOpenFileAction.selectionChanged(selection);
        menu.add((IAction)this.mOpenFileAction);
        if (selection.size() == 1 && selection.getFirstElement() instanceof IFile) {
            MenuManager submenu = new MenuManager("Open With");
            submenu.add((IContributionItem)new OpenWithMenu(this.mPage, (IAdaptable)((IFile)selection.getFirstElement())));
            menu.add((IContributionItem)submenu);
        }
    }

    public void executeDefaultAction(IStructuredSelection selection) {
        this.mOpenFileAction.selectionChanged(selection);
        this.mOpenFileAction.run();
    }
}

