/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import java.util.LinkedList;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.delta.INlpElementDelta;
import org.apache.uima.caseditor.core.model.delta.INlpModelChangeListener;
import org.apache.uima.caseditor.core.model.delta.INlpModelDeltaVisitor;
import org.apache.uima.caseditor.core.model.delta.Kind;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

class ModelChangeListener
implements INlpModelChangeListener {
    private TreeViewer mTreeViewer;

    public ModelChangeListener(TreeViewer treeViewer) {
        this.mTreeViewer = treeViewer;
    }

    public void resourceChanged(INlpElementDelta delta) {
        final LinkedList updated = new LinkedList();
        final LinkedList added = new LinkedList();
        final LinkedList removed = new LinkedList();
        INlpModelDeltaVisitor visitor = new INlpModelDeltaVisitor(){

            public boolean visit(INlpElementDelta delta) {
                if (delta.getResource().getName().equals(".corpus")) {
                    return true;
                }
                if (delta.getKind().equals((Object)Kind.CHANGED)) {
                    if (delta.isNlpElement()) {
                        updated.add(delta.getNlpElement());
                    } else {
                        updated.add(delta.getResource());
                    }
                } else if (delta.getKind().equals((Object)Kind.ADDED)) {
                    if (delta.isNlpElement()) {
                        added.add(delta.getNlpElement());
                    } else {
                        added.add(delta.getResource());
                    }
                } else if (delta.getKind() == Kind.REMOVED) {
                    if (delta.isNlpElement()) {
                        removed.add(delta.getNlpElement());
                    } else {
                        removed.add(delta.getResource());
                    }
                }
                return true;
            }
        };
        delta.accept(visitor);
        Display display = this.mTreeViewer.getControl().getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (ModelChangeListener.this.mTreeViewer.getControl().isDisposed()) {
                        return;
                    }
                    ModelChangeListener.this.mTreeViewer.remove(removed.toArray());
                    for (Object add : added) {
                        ITreeContentProvider contentProvider = (ITreeContentProvider)ModelChangeListener.this.mTreeViewer.getContentProvider();
                        ModelChangeListener.this.mTreeViewer.add(contentProvider.getParent(add), add);
                    }
                }
            });
        }
    }

    public void refresh(final INlpElement element) {
        Display display = this.mTreeViewer.getControl().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                ModelChangeListener.this.mTreeViewer.refresh((Object)element);
            }
        });
    }
}

