/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.ui.corpusview.CorpusExplorerActionGroup;
import org.apache.uima.caseditor.ui.corpusview.CorpusSorter;
import org.apache.uima.caseditor.ui.corpusview.ModelChangeListener;
import org.apache.uima.caseditor.ui.model.ElementWorkbenchAdapterFactory;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;

public final class CorpusExplorerView
extends ViewPart {
    public static final String ID = "org.apache.uima.caseditor.corpusview";
    private TreeViewer mTreeViewer;
    private CorpusExplorerActionGroup mActions;
    private ModelChangeListener mModelChangeListener;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.mTreeViewer = new TreeViewer(parent);
        this.mTreeViewer.setContentProvider((IContentProvider)new ExtendedBaseWorkbenchContentProvider());
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.mTreeViewer.setUseHashlookup(true);
        this.initContextMenu();
        this.mTreeViewer.setInput((Object)CasEditorPlugin.getNlpModel());
        this.mModelChangeListener = new ModelChangeListener(this.mTreeViewer);
        CasEditorPlugin.getNlpModel().addNlpModelChangeListener(this.mModelChangeListener);
        this.mTreeViewer.setSorter((ViewerSorter)new CorpusSorter());
        this.mActions = new CorpusExplorerActionGroup(this);
        this.initListeners();
        this.getSite().setSelectionProvider((ISelectionProvider)this.mTreeViewer);
        this.initDragAndDrop();
        this.mActions.fillActionBars(this.getViewSite().getActionBars());
        this.mActions.setContext(new ActionContext(this.mTreeViewer.getSelection()));
        this.mActions.updateActionBars();
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)CorpusExplorerView.this.mTreeViewer.getSelection();
                CorpusExplorerView.this.mActions.setContext(new ActionContext((ISelection)selection));
                CorpusExplorerView.this.mActions.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.mTreeViewer.getTree());
        this.mTreeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.mTreeViewer);
    }

    private void initListeners() {
        this.mTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object selectedElement = selection.getFirstElement();
                if (CorpusExplorerView.this.mTreeViewer.isExpandable(selectedElement)) {
                    CorpusExplorerView.this.mTreeViewer.setExpandedState(selectedElement, !CorpusExplorerView.this.mTreeViewer.getExpandedState(selectedElement));
                }
            }
        });
        this.mTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                CorpusExplorerView.this.mActions.executeDefaultAction((IStructuredSelection)event.getSelection());
            }
        });
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CorpusExplorerView.this.mActions.setContext(new ActionContext(event.getSelection()));
                CorpusExplorerView.this.mActions.updateActionBars();
            }
        });
        this.mTreeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                CorpusExplorerView.this.mActions.handleKeyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void initDragAndDrop() {
    }

    public ISelectionProvider getTreeViewer() {
        return this.mTreeViewer;
    }

    public void setFocus() {
        this.mTreeViewer.getTree().setFocus();
    }

    public void dispose() {
        super.dispose();
    }

    private static class ExtendedBaseWorkbenchContentProvider
    extends BaseWorkbenchContentProvider {
        IAdapterFactory factory = new ElementWorkbenchAdapterFactory();

        private ExtendedBaseWorkbenchContentProvider() {
        }

        protected IWorkbenchAdapter getAdapter(Object element) {
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)this.factory.getAdapter(element, IWorkbenchAdapter.class);
            if (adapter != null) {
                return adapter;
            }
            return super.getAdapter(element);
        }
    }
}

