/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

final class CorpusExplorerUtil {
    private CorpusExplorerUtil() {
    }

    static IStructuredSelection convertNLPElementsToResources(IStructuredSelection selection) {
        LinkedList<Object> newSelectionList = new LinkedList<Object>();
        for (Object element : selection) {
            if (element instanceof INlpElement) {
                INlpElement nlpElement = (INlpElement)element;
                newSelectionList.add(nlpElement.getResource());
                continue;
            }
            newSelectionList.add(element);
        }
        return new StructuredSelection(newSelectionList);
    }

    static boolean isContaingOnlyNlpElements(IStructuredSelection selection) {
        boolean isContaingOnlyNlpElements = true;
        Iterator resources = selection.iterator();
        while (resources.hasNext() && isContaingOnlyNlpElements) {
            Object resource = resources.next();
            if (resource instanceof INlpElement) continue;
            isContaingOnlyNlpElements = false;
        }
        return isContaingOnlyNlpElements;
    }
}

