/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.ui.corpusview.AnnotatorActionGroup;
import org.apache.uima.caseditor.ui.corpusview.ConsumerCorpusActionGroup;
import org.apache.uima.caseditor.ui.corpusview.CorpusExplorerView;
import org.apache.uima.caseditor.ui.corpusview.ICorpusExplorerActionGroup;
import org.apache.uima.caseditor.ui.corpusview.OpenActionGroup;
import org.apache.uima.caseditor.ui.corpusview.RefactorGroup;
import org.apache.uima.caseditor.ui.corpusview.UimaRefactorActionGroup;
import org.apache.uima.caseditor.ui.corpusview.WorkspaceActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.dialogs.PropertyDialogAction;

final class CorpusExplorerActionGroup
extends ActionGroup
implements ICorpusExplorerActionGroup {
    private OpenActionGroup openActionGroup;
    private RefactorGroup refactorGroup;
    protected ImportResourcesAction importAction;
    private WorkspaceActionGroup workspaceGroup;
    private AnnotatorActionGroup annotatorActionGroup;
    private ConsumerCorpusActionGroup consumerCorpusActionGroup;
    private UimaRefactorActionGroup uimaRefactorActionGroup;
    private PropertyDialogAction propertyAction;
    private IWorkbenchWindow mWindow;
    private IAction mRetargetPropertiesAction;

    CorpusExplorerActionGroup(CorpusExplorerView view) {
        this.mWindow = view.getSite().getPage().getWorkbenchWindow();
        Shell shell = view.getSite().getShell();
        this.openActionGroup = new OpenActionGroup(view.getSite().getPage());
        this.refactorGroup = new RefactorGroup(shell, this.mWindow);
        this.importAction = new ImportResourcesAction(this.mWindow);
        this.workspaceGroup = new WorkspaceActionGroup(shell, this.mWindow);
        this.annotatorActionGroup = new AnnotatorActionGroup(shell);
        this.consumerCorpusActionGroup = new ConsumerCorpusActionGroup(shell);
        this.uimaRefactorActionGroup = new UimaRefactorActionGroup(shell);
        this.propertyAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)shell), view.getTreeViewer());
        this.mRetargetPropertiesAction = ActionFactory.PROPERTIES.create(this.mWindow);
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean isOnlyOneResourceSelected;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        ActionFactory.IWorkbenchAction newAction = ActionFactory.NEW.create(this.mWindow);
        newAction.setText("New");
        menu.add((IAction)newAction);
        menu.add((IContributionItem)new Separator());
        this.openActionGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        this.refactorGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)ActionFactory.IMPORT.create(this.mWindow));
        menu.add((IContributionItem)new Separator());
        this.workspaceGroup.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        MenuManager taggerMenu = new MenuManager("Annotator");
        menu.add((IContributionItem)taggerMenu);
        this.annotatorActionGroup.fillContextMenu((IMenuManager)taggerMenu);
        MenuManager trainerMenu = new MenuManager("Consumer");
        menu.add((IContributionItem)trainerMenu);
        this.consumerCorpusActionGroup.fillContextMenu((IMenuManager)trainerMenu);
        MenuManager uimaRefactorMenu = new MenuManager("Refactor");
        menu.add((IContributionItem)uimaRefactorMenu);
        this.uimaRefactorActionGroup.fillContextMenu((IMenuManager)uimaRefactorMenu);
        menu.add((IContributionItem)new Separator("additions"));
        boolean bl = isOnlyOneResourceSelected = selection.size() == 1;
        if (isOnlyOneResourceSelected) {
            menu.add(this.mRetargetPropertiesAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertyAction);
        actionBars.updateActionBars();
        this.openActionGroup.fillActionBars(actionBars);
        this.refactorGroup.fillActionBars(actionBars);
        this.workspaceGroup.fillActionBars(actionBars);
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.propertyAction.setEnabled(selection.size() == 1);
        this.openActionGroup.updateActionBars();
        this.refactorGroup.updateActionBars();
        this.workspaceGroup.updateActionBars();
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.openActionGroup.setContext(context);
        this.refactorGroup.setContext(context);
        this.workspaceGroup.setContext(context);
        this.annotatorActionGroup.setContext(context);
        this.consumerCorpusActionGroup.setContext(context);
        this.uimaRefactorActionGroup.setContext(context);
    }

    public void executeDefaultAction(IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof INlpElement) {
            INlpElement nlpElement = (INlpElement)selection.getFirstElement();
            this.openActionGroup.executeDefaultAction((IStructuredSelection)new StructuredSelection((Object)nlpElement.getResource()));
        } else {
            this.openActionGroup.executeDefaultAction(selection);
        }
    }

    public void dispose() {
        super.dispose();
        this.openActionGroup.dispose();
        this.refactorGroup.dispose();
        this.importAction.dispose();
        this.workspaceGroup.dispose();
        this.annotatorActionGroup.dispose();
        this.consumerCorpusActionGroup.dispose();
        this.uimaRefactorActionGroup.dispose();
        this.propertyAction.dispose();
    }

    void handleKeyPressed(KeyEvent e) {
        this.refactorGroup.handleKeyPressed(e);
        this.workspaceGroup.handleKeyPressed(e);
    }
}

