/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import java.util.LinkedList;
import java.util.List;
import org.apache.uima.caseditor.ui.corpusview.ResourceAction;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.ResourceTransfer;

final class CopyAction
extends ResourceAction {
    private Clipboard mClipboard;

    public CopyAction(Clipboard clipboard) {
        super("Copy");
        if (clipboard == null) {
            throw new IllegalArgumentException();
        }
        this.mClipboard = clipboard;
    }

    public void run() {
        block3: {
            List<IResource> selectedResources = this.getSelectedResources();
            LinkedList<String> fileNames = new LinkedList<String>();
            LinkedList<IResource> resources = new LinkedList<IResource>();
            for (IResource resource : selectedResources) {
                IPath location = resource.getLocation();
                if (location == null) continue;
                resources.add(resource);
                fileNames.add(location.toOSString());
            }
            IResource[] resourcesArray = resources.toArray(new IResource[resources.size()]);
            String[] fileNamesArray = fileNames.toArray(new String[fileNames.size()]);
            try {
                this.mClipboard.setContents(new Object[]{resourcesArray, fileNamesArray}, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance()});
            }
            catch (SWTError e) {
                if (e.code == 2002) break block3;
                throw e;
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean result;
        int nonResources = this.getStructuredSelection().size() - this.getSelectedResources().size();
        if (nonResources > 0) {
            result = false;
        } else if (this.getSelectedResources().size() == 0) {
            result = false;
        } else {
            if (this.selectionIsOfType(4)) {
                return false;
            }
            result = !this.selectionIsOfType(4) && !this.selectionIsOfType(3) ? false : this.isAllHaveSameParent();
        }
        return result;
    }

    private boolean isAllHaveSameParent() {
        List<IResource> resources = this.getSelectedResources();
        assert (resources.size() > 0);
        IContainer parent = resources.get(0).getParent();
        for (IResource resource : resources) {
            if (resource.getParent().equals(parent)) continue;
            return false;
        }
        return true;
    }
}

