/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.caseditor.core.model.CasProcessorFolder;
import org.apache.uima.caseditor.core.model.ConsumerElement;
import org.apache.uima.caseditor.core.model.CorpusElement;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.uima.CasConsumerConfiguration;
import org.apache.uima.caseditor.ui.action.ConsumerActionRunnable;
import org.apache.uima.caseditor.ui.action.RunnableAction;
import org.apache.uima.caseditor.ui.corpusview.CorpusExplorerUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionGroup;

final class ConsumerCorpusActionGroup
extends ActionGroup {
    private Shell mShell;

    ConsumerCorpusActionGroup(Shell shell) {
        this.mShell = shell;
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (CorpusExplorerUtil.isContaingOnlyNlpElements(selection)) {
            LinkedList<CorpusElement> corpora = new LinkedList<CorpusElement>();
            for (Object resource : selection) {
                if (!(resource instanceof CorpusElement)) continue;
                corpora.add((CorpusElement)resource);
            }
            if (!corpora.isEmpty()) {
                CorpusElement aCorpus = (CorpusElement)corpora.getFirst();
                NlpProject project = aCorpus.getNlpProject();
                Collection<CasProcessorFolder> sourceFolders = project.getCasProcessorFolders();
                for (CasProcessorFolder sourceFolder : sourceFolders) {
                    Collection<ConsumerElement> consumers = sourceFolder.getConsumers();
                    for (ConsumerElement consumer : consumers) {
                        CasConsumerConfiguration config = consumer.getConsumerConfiguration();
                        if (config == null) continue;
                        ConsumerActionRunnable consumerRunnableAction = new ConsumerActionRunnable(config, corpora);
                        RunnableAction consumerAction = new RunnableAction(this.mShell, consumer.getName(), consumerRunnableAction);
                        menu.add((IAction)consumerAction);
                    }
                }
            }
        }
    }
}

