/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.corpusview;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.caseditor.core.model.AnnotatorElement;
import org.apache.uima.caseditor.core.model.CasProcessorFolder;
import org.apache.uima.caseditor.core.model.CorpusElement;
import org.apache.uima.caseditor.core.model.DocumentElement;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.uima.AnnotatorConfiguration;
import org.apache.uima.caseditor.ui.action.AnnotatorActionRunnable;
import org.apache.uima.caseditor.ui.action.RunnableAction;
import org.apache.uima.caseditor.ui.corpusview.CorpusExplorerUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionGroup;

final class AnnotatorActionGroup
extends ActionGroup {
    private Shell mShell;

    AnnotatorActionGroup(Shell shell) {
        this.mShell = shell;
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        LinkedList<DocumentElement> documentElements = new LinkedList<DocumentElement>();
        if (CorpusExplorerUtil.isContaingOnlyNlpElements(selection)) {
            for (Object resource : selection) {
                if (resource instanceof CorpusElement) {
                    documentElements.addAll(((CorpusElement)resource).getDocuments());
                }
                if (!(resource instanceof DocumentElement)) continue;
                documentElements.add((DocumentElement)resource);
            }
        }
        if (!documentElements.isEmpty()) {
            DocumentElement aDocument = (DocumentElement)documentElements.getFirst();
            NlpProject project = aDocument.getNlpProject();
            Collection<CasProcessorFolder> sourceFolders = project.getCasProcessorFolders();
            for (CasProcessorFolder sourceFolder : sourceFolders) {
                Collection<AnnotatorElement> annotators = sourceFolder.getAnnotators();
                for (AnnotatorElement annotator : annotators) {
                    AnnotatorConfiguration config = annotator.getAnnotatorConfiguration();
                    if (config == null) continue;
                    AnnotatorActionRunnable annotatorRunnableAction = new AnnotatorActionRunnable(config, documentElements);
                    RunnableAction annotatorAction = new RunnableAction(this.mShell, annotator.getName(), annotatorRunnableAction);
                    menu.add((IAction)annotatorAction);
                }
            }
        }
    }
}

