/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.action;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class RunnableAction
extends Action {
    private Shell mShell;
    private IRunnableWithProgress mRunnable;
    private String mName;

    public RunnableAction(Shell shell, String name, IRunnableWithProgress runnable) {
        Assert.isNotNull((Object)shell);
        this.mShell = shell;
        Assert.isNotNull((Object)name);
        this.mName = name;
        this.setText(name);
        Assert.isNotNull((Object)runnable);
        this.mRunnable = runnable;
    }

    public void run() {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(true, false, this.mRunnable);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.apache.uima.caseditor", 0, this.getRootCauseStackTrace(e), null);
            ErrorDialog.openError((Shell)this.mShell, (String)("Unexpected exception in " + this.mName), (String)"Unexpected exception!", (IStatus)status);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getRootCauseStackTrace(Throwable e) {
        Throwable next;
        StringBuffer b = new StringBuffer(200);
        Throwable cur = e;
        while (null != (next = cur.getCause())) {
            cur = next;
        }
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(ba);
        cur.printStackTrace(ps);
        ps.flush();
        b.append(ba.toString());
        ps.close();
        return b.toString();
    }
}

