/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.action;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.uima.cas.CAS;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.DocumentElement;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DocumentActionRunnable
implements IRunnableWithProgress {
    private final Collection<DocumentElement> documents;
    private final String taskName;

    protected DocumentActionRunnable(String taskName, Collection<DocumentElement> documents) {
        this.taskName = taskName;
        this.documents = documents;
    }

    protected void initialize() throws InvocationTargetException {
    }

    protected abstract boolean process(CAS var1) throws InvocationTargetException;

    protected void completedProcessing(IProgressMonitor monitor) throws InvocationTargetException {
    }

    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(this.taskName, this.documents.size());
        monitor.subTask("Initializing");
        this.initialize();
        HashMap<String, AnnotationEditor> editorMap = new HashMap<String, AnnotationEditor>();
        for (AnnotationEditor annotationEditor : AnnotationEditor.getAnnotationEditors()) {
            IEditorInput input = annotationEditor.getEditorInput();
            if (!(input instanceof FileEditorInput)) continue;
            FileEditorInput fileInput = (FileEditorInput)input;
            editorMap.put(fileInput.getPath().toOSString(), annotationEditor);
        }
        monitor.subTask("Processing documents, please wait!");
        for (DocumentElement documentElement : this.documents) {
            ICasDocument doc;
            try {
                doc = documentElement.getDocument(false);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            boolean wasCasChanged = this.process(doc.getCAS());
            if (wasCasChanged) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        doc.changed();
                    }
                });
                try {
                    String filename = documentElement.getResource().getLocation().toOSString();
                    if (editorMap.get(filename) == null) {
                        documentElement.saveDocument();
                    } else if (!((AnnotationEditor)editorMap.get(filename)).isDirty()) {
                        final AnnotationEditor editor = (AnnotationEditor)editorMap.get(filename);
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                editor.getDocument().changed();
                            }
                        });
                    }
                }
                catch (CoreException e) {
                    CasEditorPlugin.log(e);
                }
            }
            monitor.worked(1);
        }
        monitor.subTask("Completing processing!");
        this.completedProcessing(monitor);
        monitor.done();
    }
}

