/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.action;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.CorpusElement;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.uima.CasConsumerConfiguration;
import org.apache.uima.caseditor.uima.CorporaCollectionReader;
import org.apache.uima.collection.CollectionProcessingManager;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerActionRunnable
implements IRunnableWithProgress {
    private CasConsumerConfiguration mConfiguration;
    private Collection<CorpusElement> mCorpora;
    private boolean mIsProcessing = true;

    public ConsumerActionRunnable(CasConsumerConfiguration config, Collection<CorpusElement> corpora) {
        this.mConfiguration = config;
        this.mCorpora = corpora;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        AnalysisEngine textAnalysisEngine;
        ResourceSpecifier textAnalysisEngineSpecifier;
        CollectionReader collectionReader;
        FsIndexDescription indexDesciptor;
        TypeSystemDescription typeSystemDescriptor;
        InputStream inTypeSystemDescription;
        CollectionReaderDescription collectionReaderDescripton;
        monitor.beginTask("Consuming", -1);
        monitor.subTask("Initializing, please stand by.");
        InputStream inCollectionReaderDescripton = this.getClass().getResourceAsStream("CorporaCollectionReader.xml");
        try {
            collectionReaderDescripton = (CollectionReaderDescription)UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(inCollectionReaderDescripton, new File("")));
        }
        catch (InvalidXMLException e) {
            throw new InvocationTargetException(e, "CorporaCollectionReader.xml could ne be parsed!");
        }
        NlpProject project = this.mConfiguration.getConsumerElement().getNlpProject();
        try {
            inTypeSystemDescription = project.getDotCorpus().getTypeSystemFile().getContents();
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        try {
            typeSystemDescriptor = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(inTypeSystemDescription, new File("")));
            typeSystemDescriptor.resolveImports();
        }
        catch (InvalidXMLException e) {
            throw new InvocationTargetException(e);
        }
        ProcessingResourceMetaData collectionReaderMetaData = collectionReaderDescripton.getCollectionReaderMetaData();
        collectionReaderMetaData.setTypeSystem(typeSystemDescriptor);
        XMLParser xmlParser = UIMAFramework.getXMLParser();
        InputStream inIndex = this.getClass().getResourceAsStream("Index.xml");
        if (inIndex == null) {
            throw new InvocationTargetException(null, "org/apache/uima/caseditor/ui/action/Index.xml is missing on the classpath");
        }
        XMLInputSource xmlIndexSource = new XMLInputSource(inIndex, new File(""));
        try {
            indexDesciptor = (FsIndexDescription)xmlParser.parse(xmlIndexSource);
        }
        catch (InvalidXMLException e) {
            throw new InvocationTargetException(e);
        }
        collectionReaderMetaData.setFsIndexes(new FsIndexDescription[]{indexDesciptor});
        try {
            collectionReader = UIMAFramework.produceCollectionReader((ResourceSpecifier)collectionReaderDescripton);
        }
        catch (ResourceInitializationException e) {
            throw new InvocationTargetException(e);
        }
        ((CorporaCollectionReader)collectionReader).setCorpora(this.mCorpora);
        InputStream in = this.getClass().getResourceAsStream("DummyTAE.xml");
        try {
            textAnalysisEngineSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(in, new File("")));
        }
        catch (InvalidXMLException e) {
            throw new InvocationTargetException(e);
        }
        try {
            textAnalysisEngine = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)textAnalysisEngineSpecifier);
        }
        catch (ResourceInitializationException e) {
            throw new InvocationTargetException(e);
        }
        CollectionProcessingManager collectionProcessingEngine = UIMAFramework.newCollectionProcessingManager();
        try {
            collectionProcessingEngine.setAnalysisEngine(textAnalysisEngine);
        }
        catch (ResourceConfigurationException e) {
            throw new InvocationTargetException(e);
        }
        try {
            collectionProcessingEngine.addCasConsumer(this.mConfiguration.createConsumer());
        }
        catch (ResourceConfigurationException e) {
            throw new InvocationTargetException(e);
        }
        collectionProcessingEngine.setPauseOnException(false);
        collectionProcessingEngine.addStatusCallbackListener(new StatusCallbackListener(){

            public void entityProcessComplete(CAS cas, EntityProcessStatus status) {
            }

            public void aborted() {
                this.finishProcessing();
            }

            public void batchProcessComplete() {
            }

            public void collectionProcessComplete() {
                this.finishProcessing();
            }

            public void initializationComplete() {
            }

            public void paused() {
            }

            public void resumed() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void finishProcessing() {
                ConsumerActionRunnable consumerActionRunnable = ConsumerActionRunnable.this;
                synchronized (consumerActionRunnable) {
                    ConsumerActionRunnable.this.mIsProcessing = false;
                    ConsumerActionRunnable.this.notifyAll();
                }
            }
        });
        monitor.subTask("Feeding comsumer, please stand by.");
        try {
            collectionProcessingEngine.process(collectionReader);
        }
        catch (ResourceInitializationException e) {
            throw new InvocationTargetException(e);
        }
        ConsumerActionRunnable e = this;
        synchronized (e) {
            while (this.mIsProcessing) {
                this.wait();
            }
        }
        IFolder processorFolder = this.mConfiguration.getBaseFolder();
        try {
            processorFolder.refreshLocal(2, monitor);
        }
        catch (CoreException e2) {
            CasEditorPlugin.log(e2);
        }
        monitor.done();
    }
}

