/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ui.action;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.DocumentElement;
import org.apache.uima.caseditor.core.uima.AnnotatorConfiguration;
import org.apache.uima.caseditor.ui.action.DocumentActionRunnable;
import org.apache.uima.resource.ResourceInitializationException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatorActionRunnable
extends DocumentActionRunnable {
    private AnnotatorConfiguration mAnnotatorConfiguration;
    private AnalysisEngine annotatorInstance;

    public AnnotatorActionRunnable(AnnotatorConfiguration annotator, Collection<DocumentElement> documents) {
        super("Run Analysis Engine ", documents);
        this.mAnnotatorConfiguration = annotator;
    }

    @Override
    protected void initialize() throws InvocationTargetException {
        try {
            this.annotatorInstance = this.mAnnotatorConfiguration.createAnnotator();
        }
        catch (ResourceInitializationException e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    protected boolean process(CAS cas) throws InvocationTargetException {
        try {
            this.annotatorInstance.process(cas);
        }
        catch (AnalysisEngineProcessException e) {
            throw new InvocationTargetException(e);
        }
        return true;
    }

    @Override
    protected void completedProcessing(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            this.annotatorInstance.collectionProcessComplete();
        }
        catch (AnalysisEngineProcessException e) {
            throw new InvocationTargetException(e);
        }
        this.annotatorInstance.destroy();
        this.annotatorInstance = null;
        IFolder processorFolder = this.mAnnotatorConfiguration.getBaseFolder();
        try {
            processorFolder.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            CasEditorPlugin.log(e);
        }
    }
}

