/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.util;

import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Primitives
extends Enum<Primitives> {
    public static final /* enum */ Primitives BOOLEAN = new Primitives("uima.cas.Boolean", Boolean.class);
    public static final /* enum */ Primitives BYTE = new Primitives("uima.cas.Byte", Byte.class);
    public static final /* enum */ Primitives SHORT = new Primitives("uima.cas.Short", Short.class);
    public static final /* enum */ Primitives INTEGER = new Primitives("uima.cas.Integer", Integer.class);
    public static final /* enum */ Primitives LONG = new Primitives("uima.cas.Long", Long.class);
    public static final /* enum */ Primitives FLOAT = new Primitives("uima.cas.Float", Float.class);
    public static final /* enum */ Primitives DOUBLE = new Primitives("uima.cas.Double", Double.class);
    public static final /* enum */ Primitives STRING = new Primitives("uima.cas.String", String.class);
    private final String mTypeName;
    private final Class mType;
    private static final /* synthetic */ Primitives[] $VALUES;

    public static final Primitives[] values() {
        return (Primitives[])$VALUES.clone();
    }

    public static Primitives valueOf(String name) {
        return Enum.valueOf(Primitives.class, name);
    }

    private Primitives(String typeName, Class type) {
        this.mTypeName = typeName;
        this.mType = type;
    }

    public String getTypeName() {
        return this.mTypeName;
    }

    public Class getType() {
        return this.mType;
    }

    public boolean isCompatible(Feature feature) {
        return feature.getRange().getName().equals(this.getTypeName());
    }

    @Deprecated
    public static boolean isPrimitive(Feature f) {
        if (f == null) {
            throw new IllegalArgumentException();
        }
        return Primitives.isPrimitive(f.getRange().getName());
    }

    @Deprecated
    public static boolean isPrimitive(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException();
        }
        return Primitives.getPrimitive(typeName) != null;
    }

    public static Class getPrimitiveClass(Feature f) {
        assert (Primitives.isPrimitive(f));
        return Primitives.getPrimitive(f.getRange().getName()).getType();
    }

    public static Primitives getPrimitive(String typeName) {
        for (Primitives primitive : Primitives.values()) {
            if (!primitive.getTypeName().equals(typeName)) continue;
            return primitive;
        }
        return null;
    }

    public static Object getPrimitiv(FeatureStructure structure, Feature feature) {
        Object result;
        if (BOOLEAN.isCompatible(feature)) {
            result = structure.getBooleanValue(feature);
        } else if (BYTE.isCompatible(feature)) {
            result = structure.getByteValue(feature);
        } else if (SHORT.isCompatible(feature)) {
            result = structure.getShortValue(feature);
        } else if (INTEGER.isCompatible(feature)) {
            result = structure.getIntValue(feature);
        } else if (LONG.isCompatible(feature)) {
            result = structure.getLongValue(feature);
        } else if (FLOAT.isCompatible(feature)) {
            result = Float.valueOf(structure.getFloatValue(feature));
        } else if (DOUBLE.isCompatible(feature)) {
            result = structure.getDoubleValue(feature);
        } else if (STRING.isCompatible(feature)) {
            result = structure.getStringValue(feature);
            if (result == null) {
                result = "";
            }
        } else {
            assert (false);
            result = "unexpected type";
        }
        return result;
    }

    static {
        $VALUES = new Primitives[]{BOOLEAN, BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE, STRING};
    }
}

