/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.FeatureStructureSelectionIterator;
import org.apache.uima.caseditor.editor.util.AnnotationComparator;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSelection {
    private List<AnnotationFS> mAnnotations;

    public AnnotationSelection(Collection<FeatureStructure> structures) {
        this.mAnnotations = new ArrayList<AnnotationFS>(structures.size());
        for (FeatureStructure structure : structures) {
            if (!(structure instanceof AnnotationFS)) continue;
            this.mAnnotations.add((AnnotationFS)structure);
        }
        Collections.sort(this.mAnnotations, new AnnotationComparator());
    }

    public AnnotationSelection(IStructuredSelection selection) {
        this.mAnnotations = new ArrayList<AnnotationFS>(selection.size());
        FeatureStructureSelectionIterator it = new FeatureStructureSelectionIterator(selection);
        while (it.hasNext()) {
            FeatureStructure structure = (FeatureStructure)it.next();
            if (!(structure instanceof AnnotationFS)) continue;
            this.mAnnotations.add((AnnotationFS)structure);
        }
        Collections.sort(this.mAnnotations, new AnnotationComparator());
        this.mAnnotations = Collections.unmodifiableList(this.mAnnotations);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.mAnnotations.size();
    }

    public AnnotationFS getFirst() {
        return this.isEmpty() ? null : this.mAnnotations.get(0);
    }

    public AnnotationFS getLast() {
        return this.isEmpty() ? null : this.mAnnotations.get(this.size() - 1);
    }

    public List<AnnotationFS> toList() {
        return this.mAnnotations;
    }

    public String toString() {
        return this.mAnnotations.toString();
    }
}

