/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.outline;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.outline.AnnotationTreeNode;
import org.apache.uima.caseditor.editor.outline.AnnotationTypeTreeNode;
import org.apache.uima.caseditor.editor.outline.OutlineContentProviderBase;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeGroupedContentProvider
extends OutlineContentProviderBase {
    private Map<String, AnnotationTypeTreeNode> nameAnnotationTypeNodeMap = new HashMap<String, AnnotationTypeTreeNode>();

    TypeGroupedContentProvider(AnnotationEditor editor, TreeViewer viewer) {
        super(editor, viewer);
    }

    @Override
    protected void addedAnnotation(Collection<AnnotationFS> annotations) {
        for (AnnotationFS annotation : annotations) {
            String name = annotation.getType().getName();
            AnnotationTypeTreeNode typeNode = this.nameAnnotationTypeNodeMap.get(name);
            AnnotationTreeNode annotationNode = new AnnotationTreeNode(this.mInputDocument, annotation);
            typeNode.add(annotationNode);
            this.viewer.add((Object)typeNode, (Object)annotationNode);
        }
    }

    @Override
    protected void removedAnnotation(Collection<AnnotationFS> annotations) {
        HashSet<AnnotationTreeNode> removeAnnotations = new HashSet<AnnotationTreeNode>();
        for (AnnotationFS annotation : annotations) {
            String name = annotation.getType().getName();
            AnnotationTypeTreeNode typeNode = this.nameAnnotationTypeNodeMap.get(name);
            if (typeNode != null) {
                AnnotationTreeNode annotationNode = new AnnotationTreeNode(this.mInputDocument, annotation);
                typeNode.remove(annotationNode);
                removeAnnotations.add(annotationNode);
                continue;
            }
            CasEditorPlugin.logError("Unmapped annotation type!");
        }
        this.viewer.remove(removeAnnotations.toArray());
    }

    public Object[] getElements(Object inputElement) {
        return this.nameAnnotationTypeNodeMap.values().toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof AnnotationTreeNode) {
            AnnotationTreeNode annotation = (AnnotationTreeNode)element;
            Type type = annotation.getAnnotation().getType();
            if (type != null) {
                return this.nameAnnotationTypeNodeMap.get(type.getName());
            }
            return null;
        }
        if (element instanceof AnnotationTypeTreeNode) {
            return null;
        }
        CasEditorPlugin.logError("TypeGroupedContentProvider: Unexpected type " + element.getClass().getName());
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof AnnotationTypeTreeNode) {
            AnnotationTypeTreeNode treeNode = (AnnotationTypeTreeNode)element;
            return treeNode.getAnnotations().length > 0;
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        AnnotationTypeTreeNode typeNode = (AnnotationTypeTreeNode)parentElement;
        return typeNode.getAnnotations();
    }

    @Override
    public void changed() {
        this.nameAnnotationTypeNodeMap.clear();
        TypeSystem typeSystem = this.mInputDocument.getCAS().getTypeSystem();
        List types = typeSystem.getProperlySubsumedTypes(typeSystem.getType("uima.tcas.Annotation"));
        types.add(typeSystem.getType("uima.tcas.Annotation"));
        for (Type type : types) {
            AnnotationTypeTreeNode typeNode = new AnnotationTypeTreeNode(type);
            this.nameAnnotationTypeNodeMap.put(type.getName(), typeNode);
            CAS cas = this.mInputDocument.getCAS();
            AnnotationIndex index = cas.getAnnotationIndex(type);
            for (AnnotationFS annotation : index) {
                if (!annotation.getType().equals(type)) continue;
                typeNode.add(new AnnotationTreeNode(this.mInputDocument, annotation));
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TypeGroupedContentProvider.this.viewer.refresh();
            }
        });
    }
}

