/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.outline;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.AbstractAnnotationDocumentListener;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.outline.AnnotationTreeNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class OutlineContentProviderBase
extends AbstractAnnotationDocumentListener
implements ITreeContentProvider {
    protected AnnotationEditor mEditor;
    protected ICasDocument mInputDocument;
    protected TreeViewer viewer;

    protected OutlineContentProviderBase(AnnotationEditor editor, TreeViewer viewer) {
        this.viewer = viewer;
        this.mEditor = editor;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput != null) {
            ((ICasDocument)oldInput).removeChangeListener(this);
        }
        if (newInput != null) {
            ((ICasDocument)newInput).addChangeListener(this);
            this.mInputDocument = (ICasDocument)newInput;
            this.changed();
        }
    }

    @Override
    protected void updatedAnnotation(Collection<AnnotationFS> featureStructres) {
        ArrayList<AnnotationFS> annotations = new ArrayList<AnnotationFS>(featureStructres.size());
        for (AnnotationFS structure : featureStructres) {
            if (!(structure instanceof AnnotationFS)) continue;
            annotations.add(structure);
        }
        final Object[] items = new Object[annotations.size()];
        int i = 0;
        for (AnnotationFS annotation : annotations) {
            items[i++] = new AnnotationTreeNode(this.mEditor.getDocument(), annotation);
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                OutlineContentProviderBase.this.viewer.update(items, null);
            }
        });
    }
}

