/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.outline;

import java.util.Collection;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.Images;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.CasEditorError;
import org.apache.uima.caseditor.editor.IAnnotationEditorModifyListener;
import org.apache.uima.caseditor.editor.action.DeleteFeatureStructureAction;
import org.apache.uima.caseditor.editor.action.LowerLeftAnnotationSideAction;
import org.apache.uima.caseditor.editor.action.LowerRightAnnotationSideAction;
import org.apache.uima.caseditor.editor.action.MergeAnnotationAction;
import org.apache.uima.caseditor.editor.action.WideLeftAnnotationSideAction;
import org.apache.uima.caseditor.editor.action.WideRightAnnotationSideAction;
import org.apache.uima.caseditor.editor.outline.AnnotationTreeNode;
import org.apache.uima.caseditor.editor.outline.AnnotationTypeTreeNode;
import org.apache.uima.caseditor.editor.outline.ModeSensitiveContentProvider;
import org.apache.uima.caseditor.editor.outline.OutlineLabelProvider;
import org.apache.uima.caseditor.editor.outline.OutlineStyles;
import org.apache.uima.caseditor.editor.outline.OutlineTableSorter;
import org.apache.uima.caseditor.editor.outline.SwitchStyleAction;
import org.apache.uima.caseditor.editor.outline.TypeGroupedContentProvider;
import org.apache.uima.caseditor.editor.util.AnnotationSelection;
import org.apache.uima.caseditor.editor.util.FeatureStructureTransfer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public final class AnnotationOutline
extends ContentOutlinePage
implements ISelectionListener {
    private OutlineStyles style = OutlineStyles.TYPE;
    private Composite mOutlineComposite;
    private TreeViewer mTableViewer;
    private AnnotationEditor editor;

    public AnnotationOutline(AnnotationEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        this.mOutlineComposite = new Composite(parent, 0);
        this.mOutlineComposite.setLayout((Layout)new FillLayout());
        this.createTableViewer(this.mOutlineComposite);
        this.mOutlineComposite.layout(true);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.mTableViewer);
        this.changeAnnotationMode();
        this.editor.addAnnotationListener(new EditorListener());
        DragSource source = new DragSource((Control)this.mTableViewer.getTree(), 1);
        source.setTransfer(new Transfer[]{FeatureStructureTransfer.getInstance()});
        source.addDragListener(new DragSourceListener(){
            TreeItem dragSourceItem = null;

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = AnnotationOutline.this.mTableViewer.getTree().getSelection();
                if (selection.length > 0) {
                    event.doit = true;
                    this.dragSourceItem = selection[0];
                } else {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IAdaptable adaptable = (IAdaptable)this.dragSourceItem.getData();
                event.data = adaptable.getAdapter(FeatureStructure.class);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        WideLeftAnnotationSideAction wideLeftAnnotationSideAction = new WideLeftAnnotationSideAction(this.editor.getDocument());
        wideLeftAnnotationSideAction.setText("Wides the left annotation side");
        wideLeftAnnotationSideAction.setImageDescriptor(CasEditorPlugin.getTaeImageDescriptor(Images.WIDE_LEFT_SIDE));
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)wideLeftAnnotationSideAction);
        toolBarManager.add((IAction)wideLeftAnnotationSideAction);
        LowerLeftAnnotationSideAction lowerLeftAnnotationSideAction = new LowerLeftAnnotationSideAction(this.editor.getDocument());
        lowerLeftAnnotationSideAction.setText("Lowers the left annotation side");
        lowerLeftAnnotationSideAction.setImageDescriptor(CasEditorPlugin.getTaeImageDescriptor(Images.LOWER_LEFT_SIDE));
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)lowerLeftAnnotationSideAction);
        toolBarManager.add((IAction)lowerLeftAnnotationSideAction);
        LowerRightAnnotationSideAction lowerRightAnnotionSideAction = new LowerRightAnnotationSideAction(this.editor.getDocument());
        lowerRightAnnotionSideAction.setText("Lowers the right annotation side");
        lowerRightAnnotionSideAction.setImageDescriptor(CasEditorPlugin.getTaeImageDescriptor(Images.LOWER_RIGHT_SIDE));
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)lowerRightAnnotionSideAction);
        toolBarManager.add((IAction)lowerRightAnnotionSideAction);
        WideRightAnnotationSideAction wideRightAnnotationSideAction = new WideRightAnnotationSideAction(this.editor.getDocument());
        wideRightAnnotationSideAction.setText("Wides the right annotation side");
        wideRightAnnotationSideAction.setImageDescriptor(CasEditorPlugin.getTaeImageDescriptor(Images.WIDE_RIGHT_SIDE));
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)wideRightAnnotationSideAction);
        toolBarManager.add((IAction)wideRightAnnotationSideAction);
        MergeAnnotationAction mergeAction = new MergeAnnotationAction(this.editor.getDocument());
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)mergeAction);
        mergeAction.setImageDescriptor(CasEditorPlugin.getTaeImageDescriptor(Images.MERGE));
        toolBarManager.add((IAction)mergeAction);
        toolBarManager.add((IAction)ActionFactory.DELETE.create(this.getSite().getWorkbenchWindow()));
    }

    public Control getControl() {
        return this.mOutlineComposite;
    }

    public void setActionBars(IActionBars actionBars) {
        DeleteFeatureStructureAction deleteAction = new DeleteFeatureStructureAction(this.editor.getDocument());
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)deleteAction);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new SelectAllAction());
        SwitchStyleAction action = new SwitchStyleAction(this);
        IMenuManager dropDownMenu = actionBars.getMenuManager();
        dropDownMenu.add((IAction)action);
        super.setActionBars(actionBars);
    }

    OutlineStyles currentStyle() {
        return this.style;
    }

    void switchStyle(OutlineStyles style) {
        this.style = style;
        if (OutlineStyles.MODE.equals((Object)style)) {
            this.mTableViewer.setContentProvider((IContentProvider)new ModeSensitiveContentProvider(this.editor, this.mTableViewer));
        } else if (OutlineStyles.TYPE.equals((Object)style)) {
            this.mTableViewer.setContentProvider((IContentProvider)new TypeGroupedContentProvider(this.editor, this.mTableViewer));
        } else {
            throw new CasEditorError("Unkown style!");
        }
        this.mTableViewer.refresh();
    }

    public void setFocus() {
        this.mOutlineComposite.setFocus();
    }

    private void changeAnnotationMode() {
        this.mTableViewer.setInput((Object)this.editor.getDocument());
        this.mTableViewer.refresh();
    }

    private void createTableViewer(Composite parent) {
        int style = 68354;
        if (this.mTableViewer != null) {
            this.mTableViewer.getTree().dispose();
        }
        this.mTableViewer = new TreeViewer(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.mTableViewer.getTree().setLayoutData((Object)gridData);
        this.mTableViewer.getTree().setLinesVisible(true);
        this.mTableViewer.getTree().setHeaderVisible(true);
        TreeColumn textColumn = new TreeColumn(this.mTableViewer.getTree(), 16384);
        textColumn.setText("Text");
        textColumn.setWidth(130);
        this.mTableViewer.setUseHashlookup(false);
        this.mTableViewer.setContentProvider((IContentProvider)new TypeGroupedContentProvider(this.editor, this.mTableViewer));
        this.mTableViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Collection<Type> shownTypes = AnnotationOutline.this.editor.getShownAnnotationTypes();
                if (element instanceof AnnotationTypeTreeNode) {
                    AnnotationTypeTreeNode typeNode = (AnnotationTypeTreeNode)element;
                    return shownTypes.contains(typeNode.getType());
                }
                if (element instanceof AnnotationTreeNode) {
                    AnnotationTreeNode annotationNode = (AnnotationTreeNode)element;
                    return shownTypes.contains(annotationNode.getAnnotation().getType());
                }
                throw new CasEditorError("Unxexpected element type!");
            }
        }});
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.mTableViewer.setSorter((ViewerSorter)new OutlineTableSorter());
        this.mTableViewer.setAutoExpandLevel(3);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        AnnotationSelection annotations;
        boolean isForeignSelection;
        boolean bl = isForeignSelection = !(part instanceof ContentOutline) || ((ContentOutline)part).getCurrentPage() != this;
        if (isForeignSelection && selection instanceof StructuredSelection && !(annotations = new AnnotationSelection((IStructuredSelection)((StructuredSelection)selection))).isEmpty()) {
            StructuredSelection tableSelection = new StructuredSelection((Object)new AnnotationTreeNode(this.editor.getDocument(), annotations.getFirst()));
            this.mTableViewer.setSelection((ISelection)tableSelection, true);
        }
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    private class SelectAllAction
    extends Action {
        private SelectAllAction() {
        }

        public void run() {
            AnnotationOutline.this.mTableViewer.getTree().selectAll();
            AnnotationOutline.this.mTableViewer.setSelection(AnnotationOutline.this.mTableViewer.getSelection());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EditorListener
    implements IAnnotationEditorModifyListener {
        protected EditorListener() {
        }

        @Override
        public void annotationModeChanged(Type newMode) {
            AnnotationOutline.this.changeAnnotationMode();
            AnnotationOutline.this.mTableViewer.refresh();
        }

        @Override
        public void showAnnotationsChanged(Collection<Type> shownAnnotationTypes) {
            AnnotationOutline.this.mTableViewer.refresh();
        }
    }
}

