/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.FSConstraint;
import org.apache.uima.cas.FSIntConstraint;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.caseditor.editor.AbstractDocument;
import org.apache.uima.caseditor.editor.DocumentFormat;
import org.apache.uima.caseditor.editor.util.Span;
import org.apache.uima.caseditor.editor.util.StrictTypeConstraint;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.FsIndexDescription_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLSerializer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentUimaImpl
extends AbstractDocument {
    private final TypeSystem mTypeSystem;
    private final CAS mCAS;
    private final DocumentFormat format;

    public DocumentUimaImpl(CAS cas, InputStream in, DocumentFormat format) throws CoreException {
        this.mCAS = cas;
        this.mTypeSystem = cas.getTypeSystem();
        this.format = format;
        this.setContent(in);
    }

    @Override
    public CAS getCAS() {
        return this.mCAS;
    }

    @Override
    public void addFeatureStructure(FeatureStructure annotation) {
        this.mCAS.getIndexRepository().addFS(annotation);
        this.fireAddedFeatureStructure(annotation);
    }

    @Override
    public void addFeatureStructures(Collection<? extends FeatureStructure> annotations) {
        for (FeatureStructure featureStructure : annotations) {
            this.addFeatureStructure(featureStructure);
        }
    }

    private void removeAnnotationInternal(FeatureStructure featureStructure) {
        this.getCAS().getIndexRepository().removeFS(featureStructure);
    }

    @Override
    public void removeFeatureStructure(FeatureStructure annotation) {
        this.removeAnnotationInternal(annotation);
        this.fireRemovedFeatureStructure(annotation);
    }

    @Override
    public void removeFeatureStructures(Collection<? extends FeatureStructure> annotationsToRemove) {
        for (FeatureStructure featureStructure : annotationsToRemove) {
            this.removeAnnotationInternal(featureStructure);
        }
        if (annotationsToRemove.size() > 0) {
            this.fireRemovedFeatureStructure(annotationsToRemove);
        }
    }

    @Override
    public void update(FeatureStructure annotation) {
        this.fireUpdatedFeatureStructure(annotation);
    }

    @Override
    public void updateFeatureStructure(Collection<? extends FeatureStructure> annotations) {
        this.fireUpdatedFeatureStructure(annotations);
    }

    @Override
    public void changed() {
        this.fireChanged();
    }

    @Override
    public Collection<AnnotationFS> getAnnotations(Type type) {
        AnnotationIndex annotationIndex = this.mCAS.getAnnotationIndex(type);
        StrictTypeConstraint typeConstrain = new StrictTypeConstraint(type);
        FSIterator strictTypeIterator = this.mCAS.createFilteredIterator(annotationIndex.iterator(), (FSMatchConstraint)typeConstrain);
        return this.fsIteratorToCollection((FSIterator<AnnotationFS>)strictTypeIterator);
    }

    private Collection<AnnotationFS> fsIteratorToCollection(FSIterator<AnnotationFS> iterator) {
        LinkedList<AnnotationFS> annotations = new LinkedList<AnnotationFS>();
        while (iterator.hasNext()) {
            AnnotationFS annotation = (AnnotationFS)iterator.next();
            annotations.addFirst(annotation);
        }
        return annotations;
    }

    @Override
    public Collection<AnnotationFS> getAnnotation(Type type, Span span) {
        ConstraintFactory cf = this.getCAS().getConstraintFactory();
        Type annotationType = this.getCAS().getAnnotationType();
        FeaturePath beginPath = this.getCAS().createFeaturePath();
        beginPath.addFeature(annotationType.getFeatureByBaseName("begin"));
        FSIntConstraint beginConstraint = cf.createIntConstraint();
        beginConstraint.geq(span.getStart());
        FSMatchConstraint embeddedBegin = cf.embedConstraint(beginPath, (FSConstraint)beginConstraint);
        FeaturePath endPath = this.getCAS().createFeaturePath();
        endPath.addFeature(annotationType.getFeatureByBaseName("end"));
        FSIntConstraint endConstraint = cf.createIntConstraint();
        endConstraint.leq(span.getEnd());
        FSMatchConstraint embeddedEnd = cf.embedConstraint(endPath, (FSConstraint)endConstraint);
        StrictTypeConstraint strictType = new StrictTypeConstraint(type);
        FSMatchConstraint annotatioInSpanConstraint = cf.and(embeddedBegin, embeddedEnd);
        FSMatchConstraint annotationInSpanAndStrictTypeConstraint = cf.and(annotatioInSpanConstraint, (FSMatchConstraint)strictType);
        AnnotationIndex allAnnotations = this.getCAS().getAnnotationIndex(type);
        FSIterator annotationInsideSpanIndex = this.getCAS().createFilteredIterator(allAnnotations.iterator(), annotationInSpanAndStrictTypeConstraint);
        return this.fsIteratorToCollection((FSIterator<AnnotationFS>)annotationInsideSpanIndex);
    }

    @Override
    public Type getType(String type) {
        return this.getCAS().getTypeSystem().getType(type);
    }

    private void setContent(InputStream content) throws CoreException {
        SAXParser saxParser;
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(false);
        try {
            saxParser = saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            String message = e.getMessage() != null ? e.getMessage() : "";
            Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        catch (SAXException e) {
            String message = e.getMessage() != null ? e.getMessage() : "";
            Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        if (DocumentFormat.XCAS.equals((Object)this.format)) {
            XCASDeserializer dezerializer = new XCASDeserializer(this.mTypeSystem);
            try {
                saxParser.parse(content, dezerializer.getXCASHandler(this.mCAS));
            }
            catch (IOException e) {
                String message = e.getMessage() != null ? e.getMessage() : "";
                Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
                throw new CoreException((IStatus)s);
            }
            catch (SAXException e) {
                String message = e.getMessage() != null ? e.getMessage() : "";
                Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
                throw new CoreException((IStatus)s);
            }
        } else if (DocumentFormat.XMI.equals((Object)this.format)) {
            XmiCasDeserializer dezerializer = new XmiCasDeserializer(this.mTypeSystem);
            try {
                saxParser.parse(content, dezerializer.getXmiCasHandler(this.mCAS));
            }
            catch (IOException e) {
                String message = e.getMessage() != null ? e.getMessage() : "";
                Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
                throw new CoreException((IStatus)s);
            }
            catch (SAXException e) {
                String message = e.getMessage() != null ? e.getMessage() : "";
                Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
                throw new CoreException((IStatus)s);
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "org.apache.uima.caseditor", 0, "Unkown file format!", null));
        }
    }

    public void serialize(OutputStream out) throws CoreException {
        if (DocumentFormat.XCAS.equals((Object)this.format)) {
            XCASSerializer xcasSerializer = new XCASSerializer(this.mCAS.getTypeSystem());
            XMLSerializer xmlSerialzer = new XMLSerializer(out, true);
            try {
                xcasSerializer.serialize(this.mCAS, xmlSerialzer.getContentHandler());
            }
            catch (IOException e) {
                String message = e.getMessage() != null ? e.getMessage() : "";
                Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
                throw new CoreException((IStatus)s);
            }
            catch (SAXException e) {
                String message = e.getMessage() != null ? e.getMessage() : "";
                Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
                throw new CoreException((IStatus)s);
            }
        } else if (DocumentFormat.XMI.equals((Object)this.format)) {
            XmiCasSerializer xmiSerializer = new XmiCasSerializer(this.mCAS.getTypeSystem());
            XMLSerializer xmlSerialzer = new XMLSerializer(out, true);
            try {
                xmiSerializer.serialize(this.mCAS, xmlSerialzer.getContentHandler());
            }
            catch (SAXException e) {
                String message = e.getMessage() != null ? e.getMessage() : "";
                Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
                throw new CoreException((IStatus)s);
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "org.apache.uima.caseditor", 0, "Unkown file format!", null));
        }
    }

    public static CAS getVirginCAS(IFile typeSystemFile) throws CoreException {
        CAS cas;
        TypeSystemDescription typeSystemDesciptor;
        ResourceSpecifierFactory resourceSpecifierFactory = UIMAFramework.getResourceSpecifierFactory();
        IFile extensionTypeSystemFile = typeSystemFile;
        if (extensionTypeSystemFile == null || !extensionTypeSystemFile.exists()) {
            return null;
        }
        InputStream inTypeSystem = extensionTypeSystemFile.getContents();
        XMLInputSource xmlTypeSystemSource = new XMLInputSource(inTypeSystem, new File(""));
        XMLParser xmlParser = UIMAFramework.getXMLParser();
        try {
            typeSystemDesciptor = (TypeSystemDescription)xmlParser.parse(xmlTypeSystemSource);
            typeSystemDesciptor.resolveImports();
        }
        catch (InvalidXMLException e) {
            String message = e.getMessage() != null ? e.getMessage() : "";
            Status s = new Status(4, "org.apache.uima.dev", 0, message, (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        TypePriorities typePriorities = resourceSpecifierFactory.createTypePriorities();
        FsIndexDescription_impl indexDesciptor = new FsIndexDescription_impl();
        indexDesciptor.setLabel("TOPIndex");
        indexDesciptor.setTypeName("uima.cas.TOP");
        indexDesciptor.setKind("sorted");
        try {
            cas = CasCreationUtils.createCas((TypeSystemDescription)typeSystemDesciptor, (TypePriorities)typePriorities, (FsIndexDescription[])new FsIndexDescription[]{indexDesciptor});
        }
        catch (ResourceInitializationException e) {
            String message = e.getMessage() != null ? e.getMessage() : "";
            Status s = new Status(4, "org.apache.uima.dev", 0, message, (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        return cas;
    }
}

