/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.DefaultColors;
import org.apache.uima.caseditor.core.model.DocumentElement;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.dotcorpus.DotCorpus;
import org.apache.uima.caseditor.core.model.dotcorpus.DotCorpusSerializer;
import org.apache.uima.caseditor.editor.AnnotationDocument;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.apache.uima.caseditor.editor.CasDocumentProvider;
import org.apache.uima.caseditor.editor.DocumentFormat;
import org.apache.uima.caseditor.editor.DocumentUimaImpl;
import org.apache.uima.caseditor.editor.EditorAnnotationStatus;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCasDocumentProvider
extends CasDocumentProvider {
    private Map<String, String> documentToTypeSystemMap = new HashMap<String, String>();
    private Map<String, EditorAnnotationStatus> sharedEditorStatus = new HashMap<String, EditorAnnotationStatus>();
    private Map<String, DotCorpus> styles = new HashMap<String, DotCorpus>();

    private String getStyleFileForTypeSystem(String typeSystemFile) {
        int lastSlashIndex = typeSystemFile.lastIndexOf("/");
        String styleId = typeSystemFile.substring(0, lastSlashIndex + 1);
        styleId = styleId + ".style-" + typeSystemFile.substring(lastSlashIndex + 1);
        return styleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IDocument createDocument(Object element) throws CoreException {
        if (element instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)element;
            IFile casFile = fileInput.getFile();
            INlpElement nlpElement = CasEditorPlugin.getNlpModel().findMember((IResource)casFile);
            if (nlpElement instanceof DocumentElement) {
                try {
                    ICasDocument workingCopy = ((DocumentElement)nlpElement).getDocument(true);
                    AnnotationDocument document = new AnnotationDocument();
                    document.setDocument(workingCopy);
                    this.elementErrorStatus.remove(element);
                    return document;
                }
                catch (CoreException e) {
                    this.elementErrorStatus.put(element, new Status(4, "org.apache.uima.caseditor", 0, "There is a problem with the document: " + e.getMessage(), (Throwable)e));
                }
            } else if (CasEditorPlugin.getNlpModel().findMember((IResource)casFile.getProject()) instanceof INlpElement) {
                Status status = nlpElement == null ? new Status(4, "org.apache.uima.caseditor", 0, "Document not in a corpus folder!", null) : new Status(4, "org.apache.uima.caseditor", 0, "Not a cas document!", null);
                this.elementErrorStatus.put(element, status);
            } else {
                String typeSystemFileString = this.documentToTypeSystemMap.get(casFile.getFullPath().toPortableString());
                if (typeSystemFileString == null) {
                    typeSystemFileString = "TypeSystem.xml";
                }
                IFile typeSystemFile = null;
                IResource typeSystemResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(typeSystemFileString));
                if (typeSystemResource instanceof IFile) {
                    typeSystemFile = (IFile)typeSystemResource;
                }
                if (typeSystemFile == null) {
                    typeSystemFile = casFile.getProject().getFile(typeSystemFileString);
                }
                if (typeSystemFile.exists()) {
                    DocumentUimaImpl doc;
                    DocumentFormat documentFormat;
                    CAS cas;
                    IFile styleFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getStyleFileForTypeSystem(typeSystemFile.getFullPath().toPortableString())));
                    DotCorpus dotCorpus = this.styles.get(styleFile.getFullPath().toPortableString());
                    if (dotCorpus == null) {
                        if (styleFile.exists()) {
                            InputStream styleFileIn = null;
                            try {
                                styleFileIn = styleFile.getContents();
                                dotCorpus = DotCorpusSerializer.parseDotCorpus(styleFileIn);
                            }
                            finally {
                                if (styleFileIn != null) {
                                    try {
                                        styleFileIn.close();
                                    }
                                    catch (IOException e) {
                                        CasEditorPlugin.log(e);
                                    }
                                }
                            }
                        }
                        if (dotCorpus == null) {
                            dotCorpus = new DotCorpus();
                            cas = DocumentUimaImpl.getVirginCAS(typeSystemFile);
                            TypeSystem ts = cas.getTypeSystem();
                            Collection<AnnotationStyle> defaultStyles = dotCorpus.getAnnotationStyles();
                            Collection<AnnotationStyle> newStyles = DefaultColors.assignColors(ts, defaultStyles);
                            for (AnnotationStyle style : newStyles) {
                                dotCorpus.setStyle(style);
                            }
                        }
                        this.styles.put(styleFile.getFullPath().toPortableString(), dotCorpus);
                    }
                    this.documentToTypeSystemMap.put(casFile.getFullPath().toPortableString(), typeSystemFile.getFullPath().toPortableString());
                    cas = DocumentUimaImpl.getVirginCAS(typeSystemFile);
                    if (casFile.getName().endsWith("xmi")) {
                        documentFormat = DocumentFormat.XMI;
                    } else if (casFile.getName().endsWith("xcas")) {
                        documentFormat = DocumentFormat.XCAS;
                    } else {
                        throw new CoreException((IStatus)new Status(4, "org.apache.uima.dev", "Unkown file format!"));
                    }
                    InputStream casIn = casFile.getContents();
                    try {
                        doc = new DocumentUimaImpl(cas, casIn, documentFormat);
                    }
                    finally {
                        try {
                            casIn.close();
                        }
                        catch (IOException e) {
                            CasEditorPlugin.log(e);
                        }
                    }
                    AnnotationDocument document = new AnnotationDocument();
                    document.setDocument(doc);
                    this.elementErrorStatus.remove(element);
                    return document;
                }
                Status status = new Status(4, "org.apache.uima.dev", 12, "Cannot find type system!\nPlease place a valid type system in this path:\n" + typeSystemFile.getLocation().toOSString(), null);
                this.elementErrorStatus.put(element, status);
            }
        }
        return null;
    }

    @Override
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        this.fireElementStateChanging(element);
        if (element instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)element;
            IFile file = fileInput.getFile();
            INlpElement nlpElement = CasEditorPlugin.getNlpModel().findMember((IResource)file);
            if (nlpElement instanceof DocumentElement) {
                DocumentElement documentElement = (DocumentElement)nlpElement;
                try {
                    documentElement.saveDocument();
                }
                catch (CoreException e) {
                    this.fireElementStateChangeFailed(element);
                    throw e;
                }
            } else {
                if (CasEditorPlugin.getNlpModel().findMember((IResource)file.getProject()) instanceof INlpElement) {
                    this.fireElementStateChangeFailed(element);
                    return;
                }
                if (document instanceof AnnotationDocument) {
                    AnnotationDocument annotationDocument = (AnnotationDocument)document;
                    DocumentUimaImpl documentImpl = (DocumentUimaImpl)annotationDocument.getDocument();
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream(40000);
                    documentImpl.serialize(outStream);
                    ByteArrayInputStream stream = new ByteArrayInputStream(outStream.toByteArray());
                    file.setContents((InputStream)stream, true, false, null);
                }
            }
        }
        this.fireElementDirtyStateChanged(element, false);
    }

    private String getTypesystemId(Object element) {
        if (element instanceof FileEditorInput) {
            FileEditorInput editorInput = (FileEditorInput)element;
            return this.documentToTypeSystemMap.get(editorInput.getFile().getFullPath().toPortableString());
        }
        return null;
    }

    private DotCorpus getStyle(Object element) {
        String tsId = this.getTypesystemId(element);
        return this.styles.get(this.getStyleFileForTypeSystem(tsId));
    }

    private INlpElement getNlpElement(Object element) {
        if (element instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)element;
            IFile file = fileInput.getFile();
            return CasEditorPlugin.getNlpModel().findMember((IResource)file);
        }
        return null;
    }

    private void saveStyles(Object element) {
        String styleId = this.getStyleFileForTypeSystem(this.getTypesystemId(element));
        DotCorpus style = this.styles.get(styleId);
        IFile dotCorpusFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString((String)styleId));
        ByteArrayOutputStream dotCorpusBytes = new ByteArrayOutputStream();
        try {
            DotCorpusSerializer.serialize(style, dotCorpusBytes);
        }
        catch (CoreException e) {
            CasEditorPlugin.log(e);
        }
        try {
            if (dotCorpusFile.exists()) {
                dotCorpusFile.setContents((InputStream)new ByteArrayInputStream(dotCorpusBytes.toByteArray()), true, false, null);
            } else {
                dotCorpusFile.create((InputStream)new ByteArrayInputStream(dotCorpusBytes.toByteArray()), true, null);
            }
        }
        catch (CoreException e) {
            CasEditorPlugin.log(e);
        }
    }

    @Override
    public AnnotationStyle getAnnotationStyle(Object element, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("type parameter must not be null!");
        }
        INlpElement nlpElement = this.getNlpElement(element);
        if (nlpElement != null) {
            return nlpElement.getNlpProject().getDotCorpus().getAnnotation(type);
        }
        DotCorpus dotCorpus = this.getStyle(element);
        return dotCorpus.getAnnotation(type);
    }

    @Override
    public void setAnnotationStyle(Object element, AnnotationStyle style) {
        INlpElement nlpElement = this.getNlpElement(element);
        if (nlpElement != null) {
            nlpElement.getNlpProject().getDotCorpus().setStyle(style);
            try {
                nlpElement.getNlpProject().getDotCorpus().serialize();
            }
            catch (CoreException e) {
                CasEditorPlugin.log(e);
            }
        } else {
            DotCorpus dotCorpus = this.getStyle(element);
            dotCorpus.setStyle(style);
            this.saveStyles(element);
        }
    }

    @Override
    protected Collection<String> getShownTypes(Object element) {
        INlpElement nlpElement = this.getNlpElement(element);
        if (nlpElement != null) {
            return nlpElement.getNlpProject().getDotCorpus().getShownTypes();
        }
        DotCorpus dotCorpus = this.getStyle(element);
        return dotCorpus.getShownTypes();
    }

    @Override
    protected void addShownType(Object element, Type type) {
        INlpElement nlpElement = this.getNlpElement(element);
        if (nlpElement != null) {
            nlpElement.getNlpProject().getDotCorpus().addShownType(type.getName());
            try {
                nlpElement.getNlpProject().getDotCorpus().serialize();
            }
            catch (CoreException e) {
                CasEditorPlugin.log(e);
            }
        } else {
            DotCorpus dotCorpus = this.getStyle(element);
            dotCorpus.setShownType(type.getName());
            this.saveStyles(element);
        }
    }

    @Override
    protected void removeShownType(Object element, Type type) {
        INlpElement nlpElement = this.getNlpElement(element);
        if (nlpElement != null) {
            nlpElement.getNlpProject().getDotCorpus().removeShownType(type.getName());
            try {
                nlpElement.getNlpProject().getDotCorpus().serialize();
            }
            catch (CoreException e) {
                CasEditorPlugin.log(e);
            }
        } else {
            DotCorpus dotCorpus = this.getStyle(element);
            dotCorpus.removeShownType(type.getName());
            this.saveStyles(element);
        }
    }

    @Override
    protected EditorAnnotationStatus getEditorAnnotationStatus(Object element) {
        INlpElement nlpElement = this.getNlpElement(element);
        if (nlpElement != null) {
            return nlpElement.getNlpProject().getEditorAnnotationStatus();
        }
        EditorAnnotationStatus status = this.sharedEditorStatus.get(this.getTypesystemId(element));
        if (status == null) {
            status = new EditorAnnotationStatus("uima.tcas.Annotation", null);
        }
        return status;
    }

    @Override
    protected void setEditorAnnotationStatus(Object element, EditorAnnotationStatus editorAnnotationStatus) {
        INlpElement nlpElement = this.getNlpElement(element);
        if (nlpElement != null) {
            nlpElement.getNlpProject().setEditorAnnotationStatus(editorAnnotationStatus);
        } else {
            this.sharedEditorStatus.put(this.getTypesystemId(element), editorAnnotationStatus);
        }
    }

    void setTypeSystem(String document, String typeSystem) {
        this.documentToTypeSystemMap.put(document, typeSystem);
    }
}

