/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.awt.Color;

public final class AnnotationStyle {
    public static final Style DEFAULT_STYLE = Style.SQUIGGLES;
    public static final Color DEFAULT_COLOR = new Color(255, 0, 0);
    public static final int DEFAULT_LAYER = 0;
    private final String annotation;
    private final Style style;
    private final Color color;
    private final int layer;
    private final String configuration;

    public AnnotationStyle(String annotation, Style style, Color color, int layer, String configuration) {
        if (annotation == null || style == null || color == null) {
            throw new IllegalArgumentException("parameters must be not null!");
        }
        this.annotation = annotation;
        this.style = style;
        this.color = color;
        if (layer < 0) {
            throw new IllegalArgumentException("layer must be a positive or zero");
        }
        this.layer = layer;
        this.configuration = configuration;
    }

    public AnnotationStyle(String annotation, Style style, Color color, int layer) {
        this(annotation, style, color, layer, null);
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public Style getStyle() {
        return this.style;
    }

    public Color getColor() {
        return this.color;
    }

    public int getLayer() {
        return this.layer;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public boolean equals(Object object) {
        boolean isEqual;
        if (object == this) {
            isEqual = true;
        } else if (object instanceof AnnotationStyle) {
            AnnotationStyle style = (AnnotationStyle)object;
            boolean isConfigEqual = this.configuration == style.configuration || this.configuration == null && this.configuration.equals(style.configuration);
            isEqual = this.annotation.equals(style.annotation) && this.style.equals((Object)style.style) && this.color.equals(style.color) && this.layer == style.layer && isConfigEqual;
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String annotationStyle = "Type: " + this.annotation;
        annotationStyle = annotationStyle + " Style: " + this.getStyle().name();
        annotationStyle = annotationStyle + " Color: " + this.getColor().toString();
        annotationStyle = annotationStyle + " Layer: " + this.getLayer();
        annotationStyle = annotationStyle + " Config: " + this.getConfiguration();
        return annotationStyle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        BACKGROUND,
        TEXT_COLOR,
        TOKEN,
        SQUIGGLES,
        BOX,
        UNDERLINE,
        BRACKET,
        TAG;

    }
}

