/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.editor.AbstractAnnotationDocumentListener;
import org.apache.uima.caseditor.editor.AnnotationInformationProvider;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.apache.uima.caseditor.editor.CasDocumentProvider;
import org.apache.uima.caseditor.editor.CasDocumentProviderFactory;
import org.apache.uima.caseditor.editor.ChangeModeAction;
import org.apache.uima.caseditor.editor.DefaultCasDocumentProvider;
import org.apache.uima.caseditor.editor.EditorAnnotationStatus;
import org.apache.uima.caseditor.editor.FeatureStructureSelectionProvider;
import org.apache.uima.caseditor.editor.FindAnnotateAction;
import org.apache.uima.caseditor.editor.IAnnotationEditorModifyListener;
import org.apache.uima.caseditor.editor.IAnnotationStyleListener;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasEditor;
import org.apache.uima.caseditor.editor.ModelFeatureStructure;
import org.apache.uima.caseditor.editor.QuickTypeSelectionDialog;
import org.apache.uima.caseditor.editor.WorkspaceResourceDialog;
import org.apache.uima.caseditor.editor.action.DeleteFeatureStructureAction;
import org.apache.uima.caseditor.editor.annotation.DrawingStyle;
import org.apache.uima.caseditor.editor.annotation.EclipseAnnotationPeer;
import org.apache.uima.caseditor.editor.context.AnnotationEditingControlCreator;
import org.apache.uima.caseditor.editor.contextmenu.IModeMenuListener;
import org.apache.uima.caseditor.editor.contextmenu.IShowAnnotationsListener;
import org.apache.uima.caseditor.editor.contextmenu.ModeMenu;
import org.apache.uima.caseditor.editor.contextmenu.ShowAnnotationsMenu;
import org.apache.uima.caseditor.editor.outline.AnnotationOutline;
import org.apache.uima.caseditor.editor.util.AnnotationComparator;
import org.apache.uima.caseditor.editor.util.AnnotationSelection;
import org.apache.uima.caseditor.editor.util.FeatureStructureTransfer;
import org.apache.uima.caseditor.editor.util.Span;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationEditor
extends StatusTextEditor
implements ICasEditor,
ISelectionListener {
    private Type mAnnotationMode;
    private IContentOutlinePage mOutlinePage;
    private Set<IAnnotationEditorModifyListener> mEditorListener = new HashSet<IAnnotationEditorModifyListener>();
    private int mCursorPosition;
    boolean mIsSomethingHighlighted = false;
    private StyleRange mCurrentStyleRange;
    private FeatureStructureSelectionProvider mFeatureStructureSelectionProvider;
    private AnnotationPainter mPainter;
    private ShowAnnotationsMenu mShowAnnotationsMenu;
    private DocumentListener mAnnotationSynchronizer;
    private IAnnotationStyleListener mAnnotationStyleListener;
    private CloseEditorListener closeEditorListener;
    private Collection<Type> shownAnnotationTypes = new HashSet<Type>();

    public AnnotationEditor() {
        CasDocumentProvider provider = CasDocumentProviderFactory.instance().getDocumentProvider();
        this.setDocumentProvider((IDocumentProvider)provider);
    }

    public CasDocumentProvider getDocumentProvider() {
        return (CasDocumentProvider)super.getDocumentProvider();
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter) && this.getDocument() != null) {
            if (this.mOutlinePage == null) {
                this.mOutlinePage = new AnnotationOutline(this);
            }
            return this.mOutlinePage;
        }
        if (CAS.class.equals((Object)adapter) && this.getDocument() != null) {
            return this.getDocument().getCAS();
        }
        return super.getAdapter(adapter);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        SourceViewer sourceViewer = new SourceViewer(parent, ruler, styles);
        sourceViewer.setEditable(false);
        this.mPainter = new AnnotationPainter((ISourceViewer)sourceViewer, (IAnnotationAccess)new AnnotationAccess());
        sourceViewer.addPainter((IPainter)this.mPainter);
        return sourceViewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.showChangeInformation(false);
        this.getSourceViewer().getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int newCaretOffset = AnnotationEditor.this.getSourceViewer().getTextWidget().getCaretOffset();
                if (newCaretOffset != AnnotationEditor.this.mCursorPosition) {
                    AnnotationEditor.this.mCursorPosition = newCaretOffset;
                    AnnotationEditor.this.cursorPositionChanged();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.getSourceViewer().getTextWidget().addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                int newCaretOffset = AnnotationEditor.this.getSourceViewer().getTextWidget().getCaretOffset();
                if (newCaretOffset != AnnotationEditor.this.mCursorPosition) {
                    AnnotationEditor.this.mCursorPosition = newCaretOffset;
                    AnnotationEditor.this.cursorPositionChanged();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        DragSource dragSource = new DragSource((Control)this.getSourceViewer().getTextWidget(), 1);
        Transfer[] types = new Transfer[]{FeatureStructureTransfer.getInstance()};
        dragSource.setTransfer(types);
        dragSource.addDragListener((DragSourceListener)new FeatureStructureDragListener(this.getSourceViewer().getTextWidget()));
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSourceViewer().getTextWidget().setEditable(false);
        this.getSourceViewer().setEditable(false);
        this.getSite().setSelectionProvider((ISelectionProvider)this.mFeatureStructureSelectionProvider);
        this.initiallySynchronizeUI();
    }

    private void cursorPositionChanged() {
        this.mFeatureStructureSelectionProvider.setSelection(this.getDocument(), this.getSelectedAnnotations());
    }

    public boolean isEditable() {
        return false;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.getDocument() != null) {
            this.closeEditorListener = new CloseEditorListener(this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.closeEditorListener, 1);
            this.syncAnnotations();
            this.mAnnotationSynchronizer = new DocumentListener();
            this.getDocument().addChangeListener(this.mAnnotationSynchronizer);
            this.mAnnotationStyleListener = new IAnnotationStyleListener(){

                @Override
                public void annotationStylesChanged(Collection<AnnotationStyle> styles) {
                    AnnotationEditor.this.syncAnnotationTypes();
                }
            };
            this.getDocumentProvider().addAnnotationStyleListener(this.getEditorInput(), this.mAnnotationStyleListener);
            Collection<String> shownTypes = this.getDocumentProvider().getShownTypes(input);
            for (String shownType : shownTypes) {
                Type type = this.getDocument().getType(shownType);
                if (type == null) continue;
                this.shownAnnotationTypes.add(type);
            }
            if (this.getSourceViewer() != null) {
                this.initiallySynchronizeUI();
                IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
                for (IViewPart view : page.getViews()) {
                    if (!(view instanceof PageBookView)) continue;
                    ((PageBookView)view).partBroughtToTop(this.getEditorSite().getPart());
                }
            }
        }
    }

    private void initiallySynchronizeUI() {
        if (this.getDocument() != null) {
            this.mShowAnnotationsMenu = new ShowAnnotationsMenu(null, this.getDocument().getCAS().getTypeSystem(), this.shownAnnotationTypes);
            this.mShowAnnotationsMenu.addListener(new IShowAnnotationsListener(){

                @Override
                public void selectionChanged(Collection<Type> selection) {
                    ArrayList<Object> clonedCollection;
                    if (AnnotationEditor.this.shownAnnotationTypes.size() < selection.size()) {
                        clonedCollection = new ArrayList<Type>(selection);
                        clonedCollection.removeAll(AnnotationEditor.this.shownAnnotationTypes);
                        Type addedAnnotationType = (Type)clonedCollection.get(0);
                        AnnotationEditor.this.showAnnotationType(addedAnnotationType, true);
                        AnnotationEditor.this.getDocumentProvider().addShownType(AnnotationEditor.this.getEditorInput(), addedAnnotationType);
                    } else if (selection.size() < AnnotationEditor.this.shownAnnotationTypes.size()) {
                        clonedCollection = new ArrayList(AnnotationEditor.this.shownAnnotationTypes);
                        clonedCollection.removeAll(selection);
                        Type removedAnnotationType = (Type)clonedCollection.get(0);
                        AnnotationEditor.this.showAnnotationType(removedAnnotationType, false);
                        AnnotationEditor.this.getDocumentProvider().removeShownType(AnnotationEditor.this.getEditorInput(), removedAnnotationType);
                    }
                    AnnotationEditor.this.mPainter.paint(16);
                    EditorAnnotationStatus status = AnnotationEditor.this.getDocumentProvider().getEditorAnnotationStatus(AnnotationEditor.this.getEditorInput());
                    AnnotationEditor.this.getDocumentProvider().setEditorAnnotationStatus(AnnotationEditor.this.getEditorInput(), new EditorAnnotationStatus(status.getMode(), selection));
                    if (AnnotationEditor.this.mEditorListener != null) {
                        for (IAnnotationEditorModifyListener listener : AnnotationEditor.this.mEditorListener) {
                            listener.showAnnotationsChanged(selection);
                        }
                    }
                }
            });
            EditorAnnotationStatus status = this.getDocumentProvider().getEditorAnnotationStatus(this.getEditorInput());
            this.setAnnotationMode(this.getDocument().getType(status.getMode()));
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.appendToGroup("additions", (IContributionItem)new Separator());
        menu.appendToGroup("additions", this.getAction("org.eclipse.ui.edit.text.smartEnter"));
        menu.appendToGroup("additions", this.getAction("Enter"));
        menu.appendToGroup("additions", this.getAction("org.eclipse.ui.edit.delete"));
        TypeSystem typeSytem = this.getDocument().getCAS().getTypeSystem();
        MenuManager modeMenuManager = new MenuManager("Mode");
        menu.appendToGroup("additions", (IContributionItem)modeMenuManager);
        ModeMenu modeMenu = new ModeMenu(typeSytem);
        modeMenu.addListener(new IModeMenuListener(){

            public void modeChanged(Type newMode) {
                ChangeModeAction actionToExecute = new ChangeModeAction(newMode, newMode.getShortName(), AnnotationEditor.this);
                actionToExecute.run();
            }
        });
        modeMenuManager.add((IContributionItem)modeMenu);
        MenuManager showAnnotationMenu = new MenuManager("Show Annotations");
        menu.appendToGroup("additions", (IContributionItem)showAnnotationMenu);
        showAnnotationMenu.add((IContributionItem)this.mShowAnnotationsMenu);
    }

    private void updateStatusLineModeItem() {
        IStatusField statusField = this.getStatusField("org.apache.uima.caseditor.editor.mode.status");
        if (statusField != null) {
            statusField.setText(this.getAnnotationMode().getShortName());
        }
    }

    @Override
    public ICasDocument getDocument() {
        return (ICasDocument)this.getDocumentProvider().getDocument(this.getEditorInput());
    }

    public Type getAnnotationMode() {
        return this.mAnnotationMode;
    }

    protected void setAnnotationMode(Type type) {
        this.mAnnotationMode = type;
        this.highlight(0, 0);
        this.setProjectEditorStatus();
        this.updateStatusLineModeItem();
        this.syncAnnotationTypes();
        this.fireAnnotationTypeChanged(this.getAnnotationMode());
        this.mShowAnnotationsMenu.setEditorAnnotationMode(type);
    }

    public Collection<Type> getShownAnnotationTypes() {
        return Collections.unmodifiableCollection(this.shownAnnotationTypes);
    }

    public void setShownAnnotationType(Type type, boolean isShown) {
        this.mShowAnnotationsMenu.setSelectedType(type, isShown);
    }

    private void fireAnnotationTypeChanged(Type type) {
        if (this.mEditorListener != null) {
            for (IAnnotationEditorModifyListener listener : this.mEditorListener) {
                listener.annotationModeChanged(type);
            }
        }
    }

    private void showAnnotationType(Type type, boolean isVisible) {
        AnnotationStyle style = this.getDocumentProvider().getAnnotationStyle(this.getEditorInput(), type);
        if (isVisible) {
            AnnotationPainter.IDrawingStrategy strategy = DrawingStyle.createStrategy(style);
            if (strategy != null) {
                if (style.getStyle().equals((Object)AnnotationStyle.Style.TAG)) {
                    this.getSourceViewer().getTextWidget().setLineSpacing(13);
                }
                this.mPainter.addDrawingStrategy((Object)type.getName(), strategy);
                this.mPainter.addAnnotationType((Object)type.getName(), (Object)type.getName());
                Color color = style.getColor();
                this.mPainter.setAnnotationTypeColor((Object)type.getName(), new org.eclipse.swt.graphics.Color(null, color.getRed(), color.getGreen(), color.getBlue()));
            }
            this.shownAnnotationTypes.add(type);
        } else {
            this.mPainter.removeAnnotationType((Object)type.getName());
            this.shownAnnotationTypes.remove(type);
            if (style.getStyle().equals((Object)AnnotationStyle.Style.TAG)) {
                boolean isKeepLineSpacing = false;
                for (Type shownType : this.shownAnnotationTypes) {
                    AnnotationStyle potentialTagStyle = this.getDocumentProvider().getAnnotationStyle(this.getEditorInput(), shownType);
                    if (!AnnotationStyle.Style.TAG.equals((Object)potentialTagStyle.getStyle())) continue;
                    isKeepLineSpacing = true;
                    break;
                }
                if (!isKeepLineSpacing) {
                    this.getSourceViewer().getTextWidget().setLineSpacing(0);
                }
            }
        }
    }

    public void syncAnnotationTypes() {
        this.mPainter.removeAllAnnotationTypes();
        this.getSourceViewer().getTextWidget().setLineSpacing(0);
        for (Type displayType : this.mShowAnnotationsMenu.getSelectedTypes()) {
            this.showAnnotationType(displayType, true);
        }
        if (!this.mShowAnnotationsMenu.getSelectedTypes().contains(this.getAnnotationMode())) {
            this.showAnnotationType(this.getAnnotationMode(), true);
        }
        this.mPainter.paint(16);
    }

    private void syncAnnotations() {
        IAnnotationModel annotationModel = this.getDocumentProvider().getAnnotationModel(this.getEditorInput());
        ((IAnnotationModelExtension)annotationModel).removeAllAnnotations();
        for (AnnotationFS annotationFS : this.getDocument().getCAS().getAnnotationIndex()) {
            annotationModel.addAnnotation((Annotation)new EclipseAnnotationPeer(annotationFS), new Position(annotationFS.getBegin(), annotationFS.getEnd() - annotationFS.getBegin()));
        }
    }

    public void addAnnotationListener(IAnnotationEditorModifyListener listener) {
        this.mEditorListener.add(listener);
    }

    public Point getSelection() {
        return this.getSourceViewer().getTextWidget().getSelection();
    }

    private void highlight(int start, int length) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        assert (sourceViewer != null);
        StyledText text = sourceViewer.getTextWidget();
        if (this.mCurrentStyleRange != null) {
            StyleRange resetedStyleRange = new StyleRange(this.mCurrentStyleRange.start, this.mCurrentStyleRange.length, null, null);
            text.setStyleRange(resetedStyleRange);
        }
        if (length != 0) {
            this.mCurrentStyleRange = new StyleRange(start, length, text.getSelectionForeground(), text.getSelectionBackground());
            text.setStyleRange(this.mCurrentStyleRange);
        }
    }

    public List<AnnotationFS> getSelectedAnnotations() {
        ArrayList<AnnotationFS> selection = new ArrayList<AnnotationFS>();
        if (this.isSomethingSelected()) {
            Point selectedText = this.getSourceViewer().getTextWidget().getSelectionRange();
            Span selecectedSpan = new Span(selectedText.x, selectedText.y);
            Collection<AnnotationFS> selectedAnnotations = this.getDocument().getAnnotation(this.getAnnotationMode(), selecectedSpan);
            for (AnnotationFS annotation : selectedAnnotations) {
                selection.add(annotation);
            }
            Collections.sort(selection, new AnnotationComparator());
        } else {
            Map<Integer, AnnotationFS> view = this.getDocument().getView(this.getAnnotationMode());
            AnnotationFS annotation = view.get(this.mCursorPosition);
            if (annotation == null) {
                annotation = view.get(this.mCursorPosition - 1);
            }
            if (annotation != null) {
                selection.add(annotation);
            }
        }
        return selection;
    }

    public boolean isEditorInputModifiable() {
        return false;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            AnnotationSelection annotations = new AnnotationSelection((IStructuredSelection)((StructuredSelection)selection));
            if (this.getSite().getPage().getActiveEditor() == this && !annotations.isEmpty()) {
                this.highlight(annotations.getFirst().getBegin(), annotations.getLast().getEnd() - annotations.getFirst().getBegin());
                if (this != part) {
                    int newCaretOffset = annotations.getLast().getEnd();
                    String text = this.getSourceViewer().getTextWidget().getText();
                    if (newCaretOffset > 0 && newCaretOffset < text.length()) {
                        char beforeCaret = text.charAt(newCaretOffset - 1);
                        char afterCaret = text.charAt(newCaretOffset);
                        int cr = 13;
                        int lf = 10;
                        if (beforeCaret == '\r' && afterCaret == '\n') {
                            --newCaretOffset;
                        }
                    }
                    this.getSourceViewer().getTextWidget().setCaretOffset(newCaretOffset);
                    this.getSourceViewer().revealRange(newCaretOffset, 0);
                }
            }
        }
    }

    private boolean isSomethingSelected() {
        return this.getSourceViewer().getTextWidget().getSelectionCount() != 0;
    }

    private void setProjectEditorStatus() {
        EditorAnnotationStatus status = new EditorAnnotationStatus(this.getAnnotationMode().getName(), this.mShowAnnotationsMenu.getSelectedTypes());
        this.getDocumentProvider().setEditorAnnotationStatus(this.getEditorInput(), status);
    }

    protected void createActions() {
        super.createActions();
        this.mFeatureStructureSelectionProvider = new FeatureStructureSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.mFeatureStructureSelectionProvider);
        AnnotateAction annotateAction = new AnnotateAction(this.getSourceViewer().getTextWidget());
        String annotateActionID = "Enter";
        annotateAction.setActionDefinitionId("Enter");
        annotateAction.setText("Quick Annotate");
        annotateAction.setAccelerator(13);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)annotateAction);
        this.setAction("Enter", (IAction)annotateAction);
        this.setActionActivationCode("Enter", '\r', 13, 0);
        SmartAnnotateAction smartAnnotateAction = new SmartAnnotateAction();
        smartAnnotateAction.setActionDefinitionId("org.eclipse.ui.edit.text.smartEnter");
        smartAnnotateAction.setText("Annotate");
        smartAnnotateAction.setAccelerator(131085);
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)smartAnnotateAction);
        this.setAction("org.eclipse.ui.edit.text.smartEnter", (IAction)smartAnnotateAction);
        this.setActionActivationCode("org.eclipse.ui.edit.text.smartEnter", '\r', 13, 131072);
        DeleteFeatureStructureAction deleteAnnotationAction = new DeleteFeatureStructureAction(this.getDocument());
        deleteAnnotationAction.setText("Delete Annotation");
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)deleteAnnotationAction);
        deleteAnnotationAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setAction("org.eclipse.ui.edit.delete", (IAction)deleteAnnotationAction);
        this.setActionActivationCode("org.eclipse.ui.edit.delete", '\u0000', 13, 0);
        ShowAnnotationContextEditAction annotationContextEditAction = new ShowAnnotationContextEditAction();
        annotationContextEditAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        this.setAction("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals", (IAction)annotationContextEditAction);
        FindAnnotateAction findAnnotateAction = new FindAnnotateAction(this, this.getSourceViewer().getFindReplaceTarget());
        findAnnotateAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.setAction(ITextEditorActionConstants.FIND, (IAction)findAnnotateAction);
    }

    public void dispose() {
        CasDocumentProvider provider;
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        ICasDocument document = this.getDocument();
        if (document != null) {
            document.removeChangeListener(this.mAnnotationSynchronizer);
        }
        if (this.closeEditorListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.closeEditorListener);
        }
        if ((provider = this.getDocumentProvider()) != null) {
            provider.removeAnnotationStyleListener(this.getEditorInput(), this.mAnnotationStyleListener);
        }
        super.dispose();
    }

    void setAnnotationSelection(AnnotationFS annotation) {
        this.mFeatureStructureSelectionProvider.setSelection(this.getDocument(), annotation);
    }

    public static AnnotationEditor[] getAnnotationEditors() {
        IWorkbenchWindow[] windows;
        ArrayList<AnnotationEditor> dirtyParts = new ArrayList<AnnotationEditor>();
        for (IWorkbenchWindow element : windows = PlatformUI.getWorkbench().getWorkbenchWindows()) {
            IWorkbenchPage[] pages;
            for (IWorkbenchPage page : pages = element.getPages()) {
                IEditorReference[] references;
                for (IEditorReference reference : references = page.getEditorReferences()) {
                    IEditorPart part = reference.getEditor(false);
                    if (!(part instanceof AnnotationEditor)) continue;
                    AnnotationEditor editor = (AnnotationEditor)part;
                    dirtyParts.add(editor);
                }
            }
        }
        return dirtyParts.toArray(new AnnotationEditor[dirtyParts.size()]);
    }

    protected Control createStatusControl(Composite parent, IStatus status) {
        if (status.getCode() == 12 && this.getEditorInput() instanceof FileEditorInput) {
            Composite provideTypeSystemForm = new Composite(parent, 0);
            provideTypeSystemForm.setLayout((Layout)new GridLayout(1, false));
            Label infoLabel = new Label(provideTypeSystemForm, 0);
            infoLabel.setText(status.getMessage());
            Button retryButton = new Button(provideTypeSystemForm, 0);
            retryButton.setText("Choose Type System ...");
            retryButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IResource resource = WorkspaceResourceDialog.getWorkspaceResourceElement(Display.getCurrent().getActiveShell(), (IResource)ResourcesPlugin.getWorkspace().getRoot(), "Select a Type System", "Please select a Type System:");
                    if (resource != null) {
                        DefaultCasDocumentProvider provider = (DefaultCasDocumentProvider)AnnotationEditor.this.getDocumentProvider();
                        FileEditorInput editorInput = (FileEditorInput)AnnotationEditor.this.getEditorInput();
                        provider.setTypeSystem(editorInput.getFile().getFullPath().toPortableString(), resource.getFullPath().toPortableString());
                        AnnotationEditor.this.setInput(AnnotationEditor.this.getEditorInput());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    throw new IllegalStateException("Never be called!");
                }
            });
            return provideTypeSystemForm;
        }
        return super.createStatusControl(parent, status);
    }

    private static class CloseEditorListener
    implements IResourceChangeListener {
        private AnnotationEditor editor;

        public CloseEditorListener(AnnotationEditor editor) {
            this.editor = editor;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getFlags() != 131072 && delta.getResource().getType() == 1 && delta.getKind() == 2) {
                            FileEditorInput fileInput;
                            IResource resource = delta.getResource();
                            IEditorInput input = CloseEditorListener.this.editor.getEditorInput();
                            if (input instanceof FileEditorInput && resource.equals((fileInput = (FileEditorInput)input).getFile())) {
                                CloseEditorListener.this.editor.close(false);
                            }
                        }
                        return true;
                    }
                };
                delta.accept(visitor);
            }
            catch (CoreException e) {
                CasEditorPlugin.log(e);
            }
        }
    }

    private class AnnotationAccess
    implements IAnnotationAccess,
    IAnnotationAccessExtension {
        private AnnotationAccess() {
        }

        public Object getType(Annotation annotation) {
            return null;
        }

        public boolean isMultiLine(Annotation annotation) {
            return false;
        }

        public boolean isTemporary(Annotation annotation) {
            return false;
        }

        public int getLayer(Annotation annotation) {
            if (annotation instanceof EclipseAnnotationPeer) {
                EclipseAnnotationPeer eclipseAnnotation = (EclipseAnnotationPeer)annotation;
                AnnotationStyle style = AnnotationEditor.this.getDocumentProvider().getAnnotationStyle(AnnotationEditor.this.getEditorInput(), eclipseAnnotation.getAnnotationFS().getType());
                return style.getLayer();
            }
            return 0;
        }

        public Object[] getSupertypes(Object annotationType) {
            return new Object[0];
        }

        public String getTypeLabel(Annotation annotation) {
            return null;
        }

        public boolean isPaintable(Annotation annotation) {
            assert (false) : "Should never be called";
            return false;
        }

        public boolean isSubtype(Object annotationType, Object potentialSupertype) {
            Type type = AnnotationEditor.this.getDocument().getCAS().getTypeSystem().getType((String)annotationType);
            return AnnotationEditor.this.mShowAnnotationsMenu.getSelectedTypes().contains(type) || AnnotationEditor.this.getAnnotationMode().equals(type);
        }

        public void paint(Annotation annotation, GC gc, Canvas canvas, Rectangle bounds) {
            assert (false) : "Should never be called";
        }
    }

    private class FeatureStructureDragListener
    implements DragSourceListener {
        private boolean mIsActive;
        private AnnotationFS mCandidate;

        FeatureStructureDragListener(final StyledText textWidget) {
            textWidget.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 65536) {
                        FeatureStructureDragListener.this.mIsActive = true;
                        textWidget.setCursor(Display.getCurrent().getSystemCursor(21));
                    }
                }

                public void keyReleased(KeyEvent e) {
                    if (e.stateMask == 65536) {
                        FeatureStructureDragListener.this.mIsActive = false;
                        textWidget.setCursor(null);
                    }
                }
            });
            textWidget.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (FeatureStructureDragListener.this.mIsActive) {
                        int offset;
                        try {
                            offset = textWidget.getOffsetAtLocation(new Point(e.x, e.y));
                        }
                        catch (IllegalArgumentException e2) {
                            return;
                        }
                        Map<Integer, AnnotationFS> view = AnnotationEditor.this.getDocument().getView(AnnotationEditor.this.getAnnotationMode());
                        FeatureStructureDragListener.this.mCandidate = view.get(offset);
                        if (FeatureStructureDragListener.this.mCandidate != null) {
                            textWidget.setSelectionRange(FeatureStructureDragListener.this.mCandidate.getBegin(), FeatureStructureDragListener.this.mCandidate.getEnd() - FeatureStructureDragListener.this.mCandidate.getBegin());
                        }
                    }
                }
            });
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = this.mIsActive ? this.mCandidate != null : false;
        }

        public void dragSetData(DragSourceEvent event) {
            event.data = this.mCandidate;
        }

        public void dragFinished(DragSourceEvent event) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DocumentListener
    extends AbstractAnnotationDocumentListener {
        private DocumentListener() {
        }

        @Override
        public void addedAnnotation(Collection<AnnotationFS> annotations) {
            IAnnotationModelExtension annotationModel = (IAnnotationModelExtension)AnnotationEditor.this.getDocumentProvider().getAnnotationModel(AnnotationEditor.this.getEditorInput());
            HashMap<EclipseAnnotationPeer, Position> addAnnotationMap = new HashMap<EclipseAnnotationPeer, Position>();
            for (AnnotationFS annotation : annotations) {
                addAnnotationMap.put(new EclipseAnnotationPeer(annotation), new Position(annotation.getBegin(), annotation.getEnd() - annotation.getBegin()));
            }
            annotationModel.replaceAnnotations(null, addAnnotationMap);
        }

        @Override
        public void removedAnnotation(Collection<AnnotationFS> deletedAnnotations) {
            if (AnnotationEditor.this.getSite().getPage().getActivePart() == AnnotationEditor.this) {
                AnnotationEditor.this.mFeatureStructureSelectionProvider.clearSelection();
            } else {
                AnnotationEditor.this.mFeatureStructureSelectionProvider.clearSelectionSilently();
            }
            AnnotationEditor.this.highlight(0, 0);
            IAnnotationModelExtension annotationModel = (IAnnotationModelExtension)AnnotationEditor.this.getDocumentProvider().getAnnotationModel(AnnotationEditor.this.getEditorInput());
            Annotation[] removeAnnotations = new Annotation[deletedAnnotations.size()];
            int removeAnnotationsIndex = 0;
            for (AnnotationFS annotation : deletedAnnotations) {
                removeAnnotations[removeAnnotationsIndex++] = new EclipseAnnotationPeer(annotation);
            }
            annotationModel.replaceAnnotations(removeAnnotations, null);
        }

        @Override
        public void updatedAnnotation(Collection<AnnotationFS> annotations) {
            this.removedAnnotation(annotations);
            this.addedAnnotation(annotations);
            LinkedList<ModelFeatureStructure> structures = new LinkedList<ModelFeatureStructure>();
            for (AnnotationFS annotation : annotations) {
                structures.add(new ModelFeatureStructure(AnnotationEditor.this.getDocument(), (FeatureStructure)annotation));
            }
            AnnotationEditor.this.selectionChanged(AnnotationEditor.this.getSite().getPage().getActivePart(), (ISelection)new StructuredSelection(structures));
        }

        @Override
        public void changed() {
            AnnotationEditor.this.mFeatureStructureSelectionProvider.clearSelection();
            AnnotationEditor.this.syncAnnotations();
        }
    }

    private class ShowAnnotationContextEditAction
    extends Action {
        private InformationPresenter mPresenter = new InformationPresenter((IInformationControlCreator)new AnnotationEditingControlCreator());

        ShowAnnotationContextEditAction() {
            this.mPresenter.setInformationProvider((IInformationProvider)new AnnotationInformationProvider(AnnotationEditor.this), "__dftl_partition_content_type");
            this.mPresenter.setDocumentPartitioning("__dftl_partition_content_type");
            this.mPresenter.install((ITextViewer)AnnotationEditor.this.getSourceViewer());
        }

        public void run() {
            this.mPresenter.showInformation();
        }
    }

    private class SmartAnnotateAction
    extends AbstractAnnotateAction {
        private SmartAnnotateAction() {
        }

        public void run() {
            if (AnnotationEditor.this.isSomethingSelected()) {
                QuickTypeSelectionDialog typeDialog = new QuickTypeSelectionDialog(Display.getCurrent().getActiveShell(), AnnotationEditor.this);
                typeDialog.open();
            }
        }
    }

    private class AnnotateAction
    extends AbstractAnnotateAction {
        private StyledText mTextWidget;

        AnnotateAction(StyledText textWidget) {
            this.mTextWidget = textWidget;
        }

        public void run() {
            if (AnnotationEditor.this.isSomethingSelected()) {
                Point selection = this.mTextWidget.getSelectionRange();
                Collection<AnnotationFS> oldAnnotations = this.getDocument().getAnnotation(AnnotationEditor.this.getAnnotationMode(), new Span(selection.x, selection.y));
                if (!oldAnnotations.isEmpty()) {
                    this.getDocument().removeFeatureStructures(oldAnnotations);
                }
                int start = selection.x;
                int end = start + selection.y;
                AnnotationFS annotation = this.getDocument().getCAS().createAnnotation(AnnotationEditor.this.getAnnotationMode(), start, end);
                this.getDocument().addFeatureStructure((FeatureStructure)annotation);
                AnnotationEditor.this.setAnnotationSelection(annotation);
            }
        }

        ICasDocument getDocument() {
            return AnnotationEditor.this.getDocument();
        }
    }

    private abstract class AbstractAnnotateAction
    extends Action
    implements ISelectionChangedListener {
        private AbstractAnnotateAction() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.setEnabled(AnnotationEditor.this.getSelection().y - AnnotationEditor.this.getSelection().x > 0);
        }
    }
}

