/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.util.Collection;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasDocumentListener;
import org.apache.uima.caseditor.editor.util.Span;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDocument
extends Document
implements ICasDocument {
    private ICasDocument mDocument;
    private int lineLengthHint = 80;

    private String getText() {
        String text = this.getCAS().getDocumentText();
        if (this.lineLengthHint != 0) {
            return this.wrapWords(text, this.lineLengthHint);
        }
        return text;
    }

    private void fireDocumentChanged() {
        DocumentEvent ev = new DocumentEvent();
        ev.fDocument = this;
        this.fireDocumentChanged(ev);
    }

    public void setLineLengthHint(int lineLengthHint) {
        this.lineLengthHint = lineLengthHint;
    }

    public void setDocument(ICasDocument element) {
        this.mDocument = element;
        this.set(this.getText());
    }

    ICasDocument getDocument() {
        return this.mDocument;
    }

    @Override
    public void addFeatureStructure(FeatureStructure annotation) {
        this.mDocument.addFeatureStructure(annotation);
        this.fireDocumentChanged();
    }

    @Override
    public void addFeatureStructures(Collection<? extends FeatureStructure> annotations) {
        this.mDocument.addFeatureStructures(annotations);
        this.fireDocumentChanged();
    }

    @Override
    public void removeFeatureStructure(FeatureStructure annotation) {
        this.mDocument.removeFeatureStructure(annotation);
        this.fireDocumentChanged();
    }

    @Override
    public void removeFeatureStructures(Collection<? extends FeatureStructure> annotationsToRemove) {
        this.mDocument.removeFeatureStructures(annotationsToRemove);
        this.fireDocumentChanged();
    }

    @Override
    public void update(FeatureStructure annotation) {
        this.mDocument.update(annotation);
        this.fireDocumentChanged();
    }

    @Override
    public void updateFeatureStructure(Collection<? extends FeatureStructure> annotations) {
        this.mDocument.updateFeatureStructure(annotations);
        this.fireDocumentChanged();
    }

    @Override
    public void changed() {
        this.mDocument.changed();
        this.fireDocumentChanged();
    }

    @Override
    public Collection<AnnotationFS> getAnnotations(Type type) {
        return this.mDocument.getAnnotations(type);
    }

    @Override
    public Map<Integer, AnnotationFS> getView(Type annotationType) {
        return this.mDocument.getView(annotationType);
    }

    @Override
    public void addChangeListener(ICasDocumentListener listener) {
        this.mDocument.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ICasDocumentListener listener) {
        this.mDocument.removeChangeListener(listener);
    }

    @Override
    @Deprecated
    public Collection<AnnotationFS> getAnnotation(Type type, Span span) {
        return this.mDocument.getAnnotation(type, span);
    }

    private String wrapWords(String textString, int lineLengthHint) {
        char[] text = textString.toCharArray();
        int charCounter = 0;
        for (int i = 0; i < text.length; ++i) {
            if (text[i] == '\r' || text[i] == '\n') {
                charCounter = 0;
            }
            if (charCounter > lineLengthHint && text[i] == ' ') {
                text[i] = 10;
                charCounter = 0;
            }
            ++charCounter;
        }
        return new String(text);
    }

    @Override
    public CAS getCAS() {
        return this.mDocument.getCAS();
    }

    @Override
    public Type getType(String type) {
        return this.mDocument.getType(type);
    }
}

