/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasDocumentListener;
import org.apache.uima.caseditor.editor.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocument
implements ICasDocument {
    private Set<ICasDocumentListener> mListener = new HashSet<ICasDocumentListener>();

    @Override
    public void addChangeListener(ICasDocumentListener listener) {
        this.mListener.add(listener);
    }

    @Override
    public void removeChangeListener(ICasDocumentListener listener) {
        this.mListener.remove(listener);
    }

    protected void fireAddedFeatureStructure(FeatureStructure annotation) {
        for (ICasDocumentListener listener : this.mListener) {
            listener.added(annotation);
        }
    }

    protected void fireAddedFeatureStructure(Collection<FeatureStructure> annotations) {
        for (ICasDocumentListener listener : this.mListener) {
            listener.added(Collections.unmodifiableCollection(annotations));
        }
    }

    protected void fireRemovedFeatureStructure(FeatureStructure annotation) {
        for (ICasDocumentListener listener : this.mListener) {
            listener.removed(annotation);
        }
    }

    protected void fireRemovedFeatureStructure(Collection<? extends FeatureStructure> annotations) {
        for (ICasDocumentListener listener : this.mListener) {
            listener.removed(Collections.unmodifiableCollection(annotations));
        }
    }

    protected void fireUpdatedFeatureStructure(FeatureStructure annotation) {
        for (ICasDocumentListener listener : this.mListener) {
            listener.updated(annotation);
        }
    }

    protected void fireUpdatedFeatureStructure(Collection<? extends FeatureStructure> annotations) {
        for (ICasDocumentListener listener : this.mListener) {
            listener.updated(Collections.unmodifiableCollection(annotations));
        }
    }

    protected void fireChanged() {
        for (ICasDocumentListener listener : this.mListener) {
            listener.changed();
        }
    }

    @Override
    public Map<Integer, AnnotationFS> getView(Type annotationType) {
        Collection<AnnotationFS> annotations = this.getAnnotations(annotationType);
        HashMap<Integer, AnnotationFS> viewMap = new HashMap<Integer, AnnotationFS>();
        for (AnnotationFS annotation : annotations) {
            for (int i = annotation.getBegin(); i <= annotation.getEnd() - 1; ++i) {
                viewMap.put(i, annotation);
            }
        }
        return Collections.unmodifiableMap(viewMap);
    }

    @Override
    public Collection<AnnotationFS> getAnnotation(Type type, Span span) {
        Map<Integer, AnnotationFS> view = this.getView(type);
        LinkedList<AnnotationFS> annotations = new LinkedList<AnnotationFS>();
        for (int i = span.getStart(); i < span.getEnd(); ++i) {
            AnnotationFS annotation = view.get(i);
            if (annotation == null || !annotation.getType().equals(type)) continue;
            annotations.addLast(annotation);
        }
        TreeSet<AnnotationFS> set = new TreeSet<AnnotationFS>();
        for (AnnotationFS annotation : annotations) {
            set.add(annotation);
        }
        return Collections.unmodifiableSet(set);
    }
}

