/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.util;

import org.apache.uima.util.InvalidXMLException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.SAXParseException;

public final class MarkerUtil {
    public static final String PROBLEM_MARKER = "org.apache.uima.caseditor.problem";

    private MarkerUtil() {
    }

    public static void clearMarkers(IResource resource, String markerId) throws CoreException {
        if (resource.exists()) {
            IMarker[] markers;
            for (IMarker marker : markers = resource.findMarkers(markerId, false, 0)) {
                marker.delete();
            }
        }
    }

    public static void createMarker(IResource resource, String errorMessage) throws CoreException {
        IMarker marker = resource.createMarker(PROBLEM_MARKER);
        marker.setAttribute("severity", 2);
        marker.setAttribute("org.eclipse.core.resources.marker", (Object)"org.eclipse.core.resources.problemmarker");
        marker.setAttribute("message", (Object)errorMessage);
        marker.setAttribute("lineNumber", 1);
    }

    public static void createMarker(IResource resource, InvalidXMLException xmlException) throws CoreException {
        IMarker marker = resource.createMarker(PROBLEM_MARKER);
        marker.setAttribute("severity", 2);
        marker.setAttribute("org.eclipse.core.resources.marker", (Object)"org.eclipse.core.resources.problemmarker");
        Throwable causeException = xmlException.getCause();
        if (causeException instanceof SAXParseException) {
            SAXParseException parseException = (SAXParseException)causeException;
            marker.setAttribute("message", (Object)parseException.getMessage());
            marker.setAttribute("lineNumber", parseException.getLineNumber());
        } else {
            marker.setAttribute("message", (Object)xmlException.getMessage());
        }
    }
}

