/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.caseditor.core.util.IEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatcher<K, E> {
    private Map<K, IEventHandler<E>> mHandler = new HashMap<K, IEventHandler<E>>();
    private IEventHandler<E> mDefaultHandler;

    public EventDispatcher(IEventHandler<E> defaultHandler) {
        if (defaultHandler == null) {
            throw new IllegalArgumentException("The defaultHandler must not be null!");
        }
        this.mDefaultHandler = defaultHandler;
    }

    public void register(K key, IEventHandler<E> handler) {
        this.mHandler.put(key, handler);
    }

    public void notify(K key, E event) {
        IEventHandler<E> handler = this.mHandler.get(key);
        if (handler != null) {
            handler.handle(event);
        } else {
            this.mDefaultHandler.handle(event);
        }
    }
}

