/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.uima;

import java.net.MalformedURLException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.caseditor.core.TaeError;
import org.apache.uima.caseditor.core.model.ConsumerElement;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.eclipse.core.resources.IFolder;

public final class CasConsumerConfiguration {
    private CasConsumerDescription casConsumerDescriptor;
    private IFolder resourceBasePath;
    private ConsumerElement consumerElement;

    public CasConsumerConfiguration(ConsumerElement element, CasConsumerDescription descriptor) {
        this.casConsumerDescriptor = descriptor;
        this.consumerElement = element;
    }

    public String getName() {
        ProcessingResourceMetaData trainerMetaData = this.casConsumerDescriptor.getCasConsumerMetaData();
        return trainerMetaData.getName();
    }

    public void setBaseFolder(IFolder baseFolder) {
        this.resourceBasePath = baseFolder;
    }

    public IFolder getBaseFolder() {
        return this.resourceBasePath;
    }

    public CasConsumer createConsumer() {
        ResourceManager resourceManager = UIMAFramework.newDefaultResourceManager();
        if (this.resourceBasePath.getLocation() != null) {
            try {
                resourceManager.setExtensionClassPath(this.resourceBasePath.getLocation().toOSString(), true);
                resourceManager.setDataPath(this.resourceBasePath.getLocation().toOSString());
            }
            catch (MalformedURLException e) {
                throw new TaeError("Unexpected exception", e);
            }
        }
        try {
            CasConsumer consumer = UIMAFramework.produceCasConsumer((ResourceSpecifier)this.casConsumerDescriptor, (ResourceManager)resourceManager, null);
            return consumer;
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ConsumerElement getConsumerElement() {
        return this.consumerElement;
    }
}

