/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model.dotcorpus;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.cas.Type;
import org.apache.uima.caseditor.editor.AnnotationStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotCorpus {
    public static final int EDITOR_LINE_LENGTH_HINT_DEFAULT = 80;
    private String mTypeSystemFileName;
    private Set<String> mCorpusFolders = new HashSet<String>();
    private Set<String> mCasProcessorFolders = new HashSet<String>();
    private int mEditorLineLengthHint = 80;
    private HashMap<String, AnnotationStyle> mStyleMap = new HashMap();
    private Set<String> shownTypes = new HashSet<String>();

    public String getTypeSystemFileName() {
        return this.mTypeSystemFileName;
    }

    public void setTypeSystemFilename(String name) {
        this.mTypeSystemFileName = name;
    }

    public Collection<String> getCasProcessorFolderNames() {
        return Collections.unmodifiableCollection(this.mCasProcessorFolders);
    }

    public void addCasProcessorFolder(String folder) {
        this.mCasProcessorFolders.add(folder);
    }

    public void removeCasProcessorFolder(String folder) {
        this.mCasProcessorFolders.remove(folder);
    }

    public void addCorpusFolder(String name) {
        this.mCorpusFolders.add(name);
    }

    public void removeCorpusFolder(String name) {
        this.mCorpusFolders.remove(name);
    }

    public Collection<String> getCorpusFolderNameList() {
        return Collections.unmodifiableCollection(this.mCorpusFolders);
    }

    public int getEditorLineLengthHint() {
        return this.mEditorLineLengthHint;
    }

    public void setEditorLineLength(int lineLengthHint) {
        this.mEditorLineLengthHint = lineLengthHint;
    }

    public Collection<AnnotationStyle> getAnnotationStyles() {
        return Collections.unmodifiableCollection(this.mStyleMap.values());
    }

    public Collection<String> getShownTypes() {
        return Collections.unmodifiableCollection(this.shownTypes);
    }

    public void setShownType(String type) {
        this.shownTypes.add(type);
    }

    public void removeShownType(String type) {
        this.shownTypes.remove(type);
    }

    public void setStyle(AnnotationStyle style) {
        boolean isDefaultAnnotation;
        boolean bl = isDefaultAnnotation = AnnotationStyle.DEFAULT_COLOR.equals(style.getColor()) && AnnotationStyle.DEFAULT_STYLE.equals((Object)style.getStyle()) && 0 == style.getLayer();
        if (isDefaultAnnotation) {
            this.mStyleMap.remove(style.getAnnotation());
        } else {
            this.mStyleMap.put(style.getAnnotation(), style);
        }
    }

    public void removeStyle(String name) {
        this.mStyleMap.remove(name);
    }

    public AnnotationStyle getAnnotation(Type type) {
        AnnotationStyle style = this.mStyleMap.get(type.getName());
        if (style == null) {
            style = new AnnotationStyle(type.getName(), AnnotationStyle.DEFAULT_STYLE, AnnotationStyle.DEFAULT_COLOR, 0);
        }
        return style;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj == this) {
            result = true;
        } else if (obj instanceof DotCorpus) {
            DotCorpus corpus = (DotCorpus)obj;
            result = DotCorpus.isEqual(this.mTypeSystemFileName, corpus.mTypeSystemFileName) && DotCorpus.isEqual(this.mCorpusFolders, corpus.mCorpusFolders) && DotCorpus.isEqual(this.mCasProcessorFolders, corpus.mCasProcessorFolders) && DotCorpus.isEqual(this.mStyleMap, corpus.mStyleMap) && DotCorpus.isEqual(this.mEditorLineLengthHint, corpus.mEditorLineLengthHint);
        } else {
            result = false;
        }
        return result;
    }

    private static boolean isEqual(Object a, Object b) {
        boolean result = a != null && b != null ? a.equals(b) : a == null && b == null;
        return result;
    }
}

