/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model.delta;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.delta.INlpElementDelta;
import org.apache.uima.caseditor.core.model.delta.INlpModelDeltaVisitor;
import org.apache.uima.caseditor.core.model.delta.Kind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;

public final class NlpModelDeltaImpl
implements INlpElementDelta {
    private IResourceDelta mResourceDelta;
    private Collection<INlpElementDelta> mChildren = new LinkedList<INlpElementDelta>();
    private INlpElement mNlpElement;
    private Kind mKind;
    private NlpModelDeltaImpl mParent;

    public NlpModelDeltaImpl(NlpModelDeltaImpl parent, IResourceDelta resourceDelta) {
        IResourceDelta[] deltas;
        this.mParent = parent;
        this.mResourceDelta = resourceDelta;
        this.mKind = NlpModelDeltaImpl.getKind(resourceDelta);
        for (IResourceDelta element : deltas = this.mResourceDelta.getAffectedChildren()) {
            if (element.getFlags() == 131072) continue;
            this.mChildren.add(new NlpModelDeltaImpl(this, element));
        }
    }

    public void setNlpElement(INlpElement element) {
        this.mNlpElement = element;
    }

    public INlpElementDelta getParent() {
        return this.mParent;
    }

    public void addChild(NlpModelDeltaImpl child) {
        this.mChildren.add(child);
    }

    public void accept(INlpModelDeltaVisitor visitor) {
        boolean wantsToVisitChilds = visitor.visit(this);
        if (wantsToVisitChilds) {
            for (INlpElementDelta delta : this.getAffectedChildren()) {
                delta.accept(visitor);
            }
        }
    }

    public INlpElementDelta[] getAffectedChildren() {
        return this.mChildren.toArray(new INlpElementDelta[this.mChildren.size()]);
    }

    public boolean isNlpElement() {
        return this.mNlpElement != null;
    }

    public INlpElement getNlpElement() {
        return this.mNlpElement;
    }

    public IResource getResource() {
        return this.mResourceDelta.getResource();
    }

    public Kind getKind() {
        return this.mKind;
    }

    public void setKind(Kind kind) {
        this.mKind = kind;
    }

    public int getFlags() {
        return this.mResourceDelta.getFlags();
    }

    public IResourceDelta getResourceDelta() {
        return this.mResourceDelta;
    }

    public IPath getMovedFromPath() {
        return this.mResourceDelta.getMovedFromPath();
    }

    public IPath getMovedToPath() {
        return this.mResourceDelta.getMovedToPath();
    }

    public String toString() {
        return (this.isNlpElement() ? "Nlp: " : "") + this.mResourceDelta.toString();
    }

    private static Kind getKind(IResourceDelta delta) {
        Kind kind = (delta.getKind() & 9) != 0 ? Kind.ADDED : ((delta.getKind() & 0x12) != 0 ? Kind.REMOVED : ((delta.getKind() & 4) != 0 ? Kind.CHANGED : null));
        return kind;
    }
}

