/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model;

import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.AbstractNlpElement;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.NlpModel;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.model.delta.INlpElementDelta;
import org.apache.uima.caseditor.core.util.MarkerUtil;
import org.apache.uima.caseditor.editor.DocumentUimaImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class TypesystemElement
extends AbstractNlpElement {
    private IFile mTypesytemFile;
    private NlpProject mProject;

    TypesystemElement(IFile resource, NlpProject parent) {
        this.mTypesytemFile = resource;
        this.mProject = parent;
        this.getCAS();
    }

    public TypeSystem getTypeSystem() {
        CAS cas = this.getCAS();
        if (cas != null) {
            return cas.getTypeSystem();
        }
        return null;
    }

    public CAS getCAS() {
        Runnable clearMarkers = new Runnable(){

            public void run() {
                try {
                    MarkerUtil.clearMarkers((IResource)TypesystemElement.this.mTypesytemFile, "org.apache.uima.caseditor.problem");
                }
                catch (CoreException e) {
                    CasEditorPlugin.log(e);
                }
            }
        };
        ((NlpModel)this.mProject.getParent()).asyncExcuteQueue(clearMarkers);
        try {
            return DocumentUimaImpl.getVirginCAS(this.mTypesytemFile);
        }
        catch (CoreException e) {
            Runnable createMarker = new Runnable(){

                public void run() {
                    try {
                        MarkerUtil.createMarker((IResource)TypesystemElement.this.mTypesytemFile, e.getMessage());
                    }
                    catch (CoreException e2) {
                        CasEditorPlugin.log(e2);
                    }
                }
            };
            ((NlpModel)this.mProject.getParent()).asyncExcuteQueue(createMarker);
            return null;
        }
    }

    public String getName() {
        return "Typesystem";
    }

    public NlpProject getNlpProject() {
        return this.mProject;
    }

    public INlpElement getParent() {
        return this.mProject;
    }

    public IResource getResource() {
        return this.mTypesytemFile;
    }

    void changedResource(IResource resource, INlpElementDelta delta) throws CoreException {
        this.getCAS();
    }

    void addResource(INlpElementDelta delta, IResource resource) throws CoreException {
    }

    void removeResource(INlpElementDelta delta, IResource resource) throws CoreException {
    }
}

