/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.AbstractNlpElement;
import org.apache.uima.caseditor.core.model.CasProcessorFolder;
import org.apache.uima.caseditor.core.model.CorpusElement;
import org.apache.uima.caseditor.core.model.DefaultColors;
import org.apache.uima.caseditor.core.model.DotCorpusElement;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.NlpModel;
import org.apache.uima.caseditor.core.model.TypesystemElement;
import org.apache.uima.caseditor.core.model.delta.INlpElementDelta;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.apache.uima.caseditor.editor.EditorAnnotationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NlpProject
extends AbstractNlpElement
implements IProjectNature,
INlpElement,
IAdaptable {
    public static final String ID = "org.apache.uima.caseditor.NLPProject";
    private static final String DOT_CORPUS_FILENAME = ".corpus";
    private NlpModel mModel;
    private IProject mProject;
    private DotCorpusElement mDotCorpusElement;
    private Collection<CorpusElement> mCopora = new LinkedList<CorpusElement>();
    private Collection<CasProcessorFolder> mUimaSourceFolder = new LinkedList<CasProcessorFolder>();
    private boolean mDotCorpusMustBeSerialized;
    private boolean mIsDotCorpusDirty;
    private EditorAnnotationStatus mEditorAnnotationStatus;
    private TypesystemElement mTypesystem;

    void setNlpModel(NlpModel model) {
        this.mModel = model;
    }

    void initialize() throws CoreException {
        this.loadDotCorpus();
        this.createCorpora();
        for (CorpusElement corpus : this.getCorpora()) {
            corpus.initialize();
        }
        this.createCasProcessorFolders();
        IFile typeSystemFile = this.getDotCorpus().getTypeSystemFile();
        if (typeSystemFile != null && typeSystemFile.exists()) {
            this.mTypesystem = new TypesystemElement(typeSystemFile, this);
        }
        if (this.getTypesystemElement() != null && this.getTypesystemElement().getTypeSystem() != null) {
            TypeSystem typeSystem = this.getTypesystemElement().getTypeSystem();
            Type annotationType = typeSystem.getType("uima.tcas.Annotation");
            List displayTypes = typeSystem.getProperlySubsumedTypes(annotationType);
            displayTypes.remove(typeSystem.getType("uima.tcas.DocumentAnnotation"));
            this.mEditorAnnotationStatus = new EditorAnnotationStatus(annotationType.getName(), displayTypes);
        }
    }

    @Override
    public String getName() {
        return this.mProject.getName();
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    @Override
    public INlpElement getParent() {
        return this.mModel;
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.mProject;
    }

    public void setProject(IProject project) {
        this.mProject = project;
    }

    public EditorAnnotationStatus getEditorAnnotationStatus() {
        return this.mEditorAnnotationStatus;
    }

    public void setEditorAnnotationStatus(EditorAnnotationStatus status) {
        this.mEditorAnnotationStatus = status;
    }

    private void loadDotCorpus() {
        IFile dotCorpusResource = this.getProject().getFile(DOT_CORPUS_FILENAME);
        this.mDotCorpusElement = DotCorpusElement.createDotCorpus(dotCorpusResource, this);
    }

    public Collection<CorpusElement> getCorpora() {
        return this.mCopora;
    }

    private void createCorpora() {
        for (IFolder corpusFolderName : this.mDotCorpusElement.getCorpusFolderNameList()) {
            if (!corpusFolderName.exists()) continue;
            CorpusElement corpusElement = new CorpusElement(this, corpusFolderName);
            this.mCopora.add(corpusElement);
        }
    }

    public IResource[] getResources() throws CoreException {
        IResource[] resources = this.mProject.members();
        LinkedList<IResource> resourceList = new LinkedList<IResource>();
        for (IResource element : resources) {
            if (this.isSpecialResource(element) || element instanceof IFolder && (this.mDotCorpusElement.isCorpusFolder((IFolder)element) || this.mDotCorpusElement.isCasProcessorFolder((IFolder)element)) || this.mTypesystem != null && this.mTypesystem.getResource().equals(element)) continue;
            resourceList.add(element);
        }
        IResource[] filteredResources = new IResource[resourceList.size()];
        return resourceList.toArray(filteredResources);
    }

    @Override
    public INlpElement getParent(IResource resource) throws CoreException {
        INlpElement result = super.getParent(resource);
        if (result == null) {
            if (this.mDotCorpusElement != null && this.mDotCorpusElement.getResource().equals(resource)) {
                return this;
            }
            if (this.mTypesystem != null && this.mTypesystem.getResource().equals(resource)) {
                return this;
            }
            for (IResource candiadte : this.getResources()) {
                if (!candiadte.equals(resource)) continue;
                return this;
            }
            for (CorpusElement corpus : this.getCorpora()) {
                INlpElement element = corpus.getParent(resource);
                if (element == null) continue;
                return element;
            }
            for (CasProcessorFolder sourceFolder : this.getCasProcessorFolders()) {
                INlpElement element = sourceFolder.getParent(resource);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public INlpElement findMember(IResource resource) {
        INlpElement result = super.findMember(resource);
        if (result == null) {
            boolean isElementFound;
            if (DOT_CORPUS_FILENAME.equals(resource.getName())) {
                return this.mDotCorpusElement;
            }
            if (this.mTypesystem != null && this.mTypesystem.findMember(resource) != null) {
                return this.mTypesystem.findMember(resource);
            }
            for (CasProcessorFolder sourceFolder : this.getCasProcessorFolders()) {
                isElementFound = sourceFolder.findMember(resource) != null;
                if (!isElementFound) continue;
                return sourceFolder.findMember(resource);
            }
            for (CorpusElement corpus : this.getCorpora()) {
                isElementFound = corpus.findMember(resource) != null;
                if (!isElementFound) continue;
                return corpus.findMember(resource);
            }
        }
        return result;
    }

    public Collection<CasProcessorFolder> getCasProcessorFolders() {
        return this.mUimaSourceFolder;
    }

    private void createCasProcessorFolders() throws CoreException {
        for (IFolder processorFolder : this.mDotCorpusElement.getCasProcessorFolders()) {
            if (!processorFolder.exists()) continue;
            CasProcessorFolder processorElement = new CasProcessorFolder(processorFolder, this);
            this.mUimaSourceFolder.add(processorElement);
        }
    }

    public DotCorpusElement getDotCorpus() {
        Assert.isTrue((this.mDotCorpusElement != null ? 1 : 0) != 0);
        return this.mDotCorpusElement;
    }

    @Override
    public NlpProject getNlpProject() {
        return this;
    }

    private boolean isSpecialResource(IResource resource) {
        String[] specialResource;
        for (String element : specialResource = new String[]{".project", DOT_CORPUS_FILENAME}) {
            if (!resource.getName().equals(element)) continue;
            return true;
        }
        return false;
    }

    private void updateAnnotationTypeColors() throws CoreException {
        TypeSystem ts;
        ArrayList<AnnotationStyle> styles = new ArrayList<AnnotationStyle>();
        styles.addAll(this.getDotCorpus().getAnnotationStyles());
        if (this.getTypesystemElement() != null && (ts = this.getTypesystemElement().getTypeSystem()) != null) {
            Collection<AnnotationStyle> newStyles = DefaultColors.assignColors(ts, styles);
            for (AnnotationStyle style : newStyles) {
                this.getDotCorpus().setStyle(style);
            }
            if (styles.size() != newStyles.size()) {
                this.mDotCorpusMustBeSerialized = true;
            }
        }
    }

    @Override
    public void addResource(INlpElementDelta delta, IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (DOT_CORPUS_FILENAME.equals(file.getName())) {
                this.mIsDotCorpusDirty = true;
            } else if (this.mDotCorpusElement.getTypeSystemFile() != null && (delta.getFlags() & 0x1000) > 0 && this.mDotCorpusElement.getTypeSystemFile().getFullPath().equals(delta.getMovedFromPath())) {
                this.mDotCorpusElement.setTypeSystemFilename(resource.getName());
                Runnable serialze = new Runnable(){

                    public void run() {
                        try {
                            NlpProject.this.mDotCorpusElement.serialize();
                        }
                        catch (CoreException e) {
                            CasEditorPlugin.log(e);
                        }
                    }
                };
                ((NlpModel)this.getNlpProject().getParent()).asyncExcuteQueue(serialze);
            } else if (this.mDotCorpusElement.getTypeSystemFile() != null && this.mDotCorpusElement.getTypeSystemFile().equals(resource)) {
                this.mTypesystem = new TypesystemElement((IFile)resource, this);
                this.updateAnnotationTypeColors();
            }
        } else if (resource instanceof IFolder) {
            if (this.mDotCorpusElement.isCorpusFolder((IFolder)resource)) {
                this.mCopora.add(new CorpusElement(this.getNlpProject(), (IFolder)resource));
            } else if (this.mDotCorpusElement.isCasProcessorFolder((IFolder)resource)) {
                this.mUimaSourceFolder.add(new CasProcessorFolder((IFolder)resource, this.getNlpProject()));
            }
        }
    }

    @Override
    public void removeResource(INlpElementDelta delta, IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (DOT_CORPUS_FILENAME.equals(file.getName())) {
                this.mIsDotCorpusDirty = true;
            }
            if (this.mTypesystem != null && resource.equals(this.mTypesystem.getResource())) {
                this.mTypesystem = null;
            }
        }
        for (CasProcessorFolder sourceFolder : this.mUimaSourceFolder) {
            if (!sourceFolder.getResource().equals(resource)) continue;
            this.mUimaSourceFolder.remove(sourceFolder);
            break;
        }
        for (CorpusElement corpus : this.mCopora) {
            if (!corpus.getResource().equals(resource)) continue;
            this.mCopora.remove(corpus);
            break;
        }
    }

    @Override
    void changedResource(IResource resource, INlpElementDelta delta) throws CoreException {
        if (DOT_CORPUS_FILENAME.equals(resource.getName())) {
            this.mIsDotCorpusDirty = true;
        } else if (this.mTypesystem != null && resource.equals(this.mTypesystem.getResource())) {
            this.mTypesystem.changedResource(resource, delta);
            if (this.getTypesystemElement().getTypeSystem() != null) {
                this.updateAnnotationTypeColors();
                this.mEditorAnnotationStatus = new EditorAnnotationStatus("uima.tcas.Annotation", null);
            }
        }
    }

    void postProcessResourceChanges() throws CoreException {
        if (this.mIsDotCorpusDirty) {
            this.mIsDotCorpusDirty = false;
            this.mDotCorpusElement = null;
            this.loadDotCorpus();
            this.mUimaSourceFolder.clear();
            this.mCopora.clear();
            this.mTypesystem = null;
            this.initialize();
            this.updateAnnotationTypeColors();
            CasEditorPlugin.getNlpModel().fireRefreshEvent(this);
        }
        if (this.mDotCorpusMustBeSerialized) {
            this.mDotCorpusMustBeSerialized = false;
            Runnable writeDotCorpus = new Runnable(){

                public void run() {
                    try {
                        NlpProject.this.getDotCorpus().serialize();
                    }
                    catch (CoreException e) {
                        CasEditorPlugin.log(e);
                    }
                }
            };
            CasEditorPlugin.getNlpModel().asyncExcuteQueue(writeDotCorpus);
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        boolean isEqual;
        if (obj != null && obj instanceof NlpProject) {
            NlpProject project = (NlpProject)obj;
            isEqual = this.getResource().equals(project.getResource());
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    public static void addNLPNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = ID;
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public TypesystemElement getTypesystemElement() {
        return this.mTypesystem;
    }
}

