/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.AbstractNlpElement;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.model.delta.AbstractResourceDelta;
import org.apache.uima.caseditor.core.model.delta.INlpElementDelta;
import org.apache.uima.caseditor.core.model.delta.INlpModelChangeListener;
import org.apache.uima.caseditor.core.model.delta.Kind;
import org.apache.uima.caseditor.core.model.delta.NlpModelDeltaImpl;
import org.apache.uima.caseditor.core.util.EventDispatcher;
import org.apache.uima.caseditor.core.util.IEventHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public final class NlpModel
extends AbstractNlpElement {
    private Set<INlpModelChangeListener> mModelChangeListeners = new HashSet<INlpModelChangeListener>();
    private IWorkspaceRoot mWorkspaceRoot;
    private List<NlpProject> mNlpProjects;
    private ExecutorService mAsynchronExecutor = Executors.newSingleThreadExecutor();
    private ResourceChangeListener mListener;

    public NlpModel() throws CoreException {
        this.mWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.mNlpProjects = new LinkedList<NlpProject>();
        this.createNlpProjects();
        this.createModelSynchronizer();
    }

    private void handleExceptionDuringResoruceChange(CoreException e) {
        CasEditorPlugin.log(e);
    }

    void changeInternal(INlpElementDelta delta) {
        IResource resource = delta.getResource();
        IContainer parent = resource.getParent();
        AbstractNlpElement parentElement = (AbstractNlpElement)this.findMember((IResource)parent);
        if (parentElement != null) {
            try {
                parentElement.changedResource(resource, delta);
            }
            catch (CoreException e) {
                this.handleExceptionDuringResoruceChange(e);
            }
        }
    }

    void addInternal(INlpElementDelta delta, IResource resource) {
        if (resource.equals(this.mWorkspaceRoot)) {
            return;
        }
        IContainer parent = resource.getParent();
        AbstractNlpElement parentElement = (AbstractNlpElement)this.findMember((IResource)parent);
        if (parentElement != null) {
            try {
                parentElement.addResource(delta, resource);
            }
            catch (CoreException e) {
                this.handleExceptionDuringResoruceChange(e);
            }
        }
    }

    void addResource(INlpElementDelta delta, IResource resource) throws CoreException {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            this.createNlpProject(project);
        }
    }

    void removeInternal(INlpElementDelta delta, IResource resource) {
        IContainer parent = resource.getParent();
        AbstractNlpElement parentElement = (AbstractNlpElement)this.findMember((IResource)parent);
        if (parentElement != null) {
            try {
                parentElement.removeResource(delta, resource);
            }
            catch (CoreException e) {
                this.handleExceptionDuringResoruceChange(e);
            }
        }
    }

    void removeResource(INlpElementDelta delta, IResource resource) {
        for (NlpProject project : this.mNlpProjects) {
            if (!project.getResource().equals(resource)) continue;
            this.mNlpProjects.remove(project);
            break;
        }
    }

    public NlpProject[] getNlpProjects() {
        return this.mNlpProjects.toArray(new NlpProject[this.mNlpProjects.size()]);
    }

    private void createNlpProject(IProject project) throws CoreException {
        if (project.isOpen() && project.hasNature("org.apache.uima.caseditor.NLPProject")) {
            NlpProject nlpProject = (NlpProject)project.getNature("org.apache.uima.caseditor.NLPProject");
            nlpProject.setNlpModel(this);
            nlpProject.initialize();
            this.mNlpProjects.add(nlpProject);
        }
    }

    private void createNlpProjects() throws CoreException {
        IProject[] projects;
        for (IProject project : projects = this.mWorkspaceRoot.getProjects()) {
            this.createNlpProject(project);
        }
    }

    public IProject[] getNonNlpProjects() throws CoreException {
        IProject[] allProjects = this.mWorkspaceRoot.getProjects();
        LinkedList<IProject> otherProjectList = new LinkedList<IProject>();
        for (int i = 0; i < allProjects.length; ++i) {
            if (allProjects[i].isOpen()) {
                if (allProjects[i].hasNature("org.apache.uima.caseditor.NLPProject")) continue;
                otherProjectList.add(allProjects[i]);
                continue;
            }
            otherProjectList.add(allProjects[i]);
        }
        IProject[] otherProjects = new IProject[otherProjectList.size()];
        return otherProjectList.toArray(otherProjects);
    }

    public IResource getResource() {
        return this.mWorkspaceRoot;
    }

    public String getName() {
        return this.mWorkspaceRoot.getName();
    }

    public INlpElement getParent(IResource resource) throws CoreException {
        INlpElement result = super.getParent(resource);
        if (result == null) {
            for (NlpProject nlpProject : this.getNlpProjects()) {
                result = nlpProject.getParent(resource);
                if (result == null) continue;
                return result;
            }
            for (NlpProject nlpProject : this.getNonNlpProjects()) {
                if (!((Object)nlpProject).equals(resource)) continue;
                return this;
            }
        }
        return result;
    }

    public INlpElement findMember(IResource resource) {
        INlpElement result = super.findMember(resource);
        if (result == null) {
            for (NlpProject project : this.getNlpProjects()) {
                boolean isNlpElement;
                boolean bl = isNlpElement = project.findMember(resource) != null;
                if (!isNlpElement) continue;
                return project.findMember(resource);
            }
        }
        return result;
    }

    public boolean isNlpElement(IResource resource) {
        return this.findMember(resource) != null;
    }

    public INlpElement getParent() {
        return null;
    }

    public NlpProject getNlpProject() {
        return null;
    }

    public void addNlpModelChangeListener(INlpModelChangeListener listener) {
        this.mModelChangeListeners.add(listener);
    }

    public void removeNlpModelChangeListener(INlpModelChangeListener listener) {
        this.mModelChangeListeners.remove(listener);
    }

    void createModelSynchronizer() {
        this.mListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.mListener);
    }

    public String toString() {
        return this.getResource().toString();
    }

    void fireRefreshEvent(INlpElement element) {
        for (INlpModelChangeListener listener : this.mModelChangeListeners) {
            listener.refresh(element);
        }
    }

    public void asyncExcuteQueue(Runnable worker) {
        this.mAsynchronExecutor.submit(worker);
    }

    public void destroyForTesting() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.mListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangedHandler
    extends AbstractEventHandler {
        ChangedHandler(EventDispatcher<Kind, NlpModelDeltaImpl> handler) {
            super(handler);
        }

        @Override
        public void handle(NlpModelDeltaImpl delta) {
            if (delta.getResource() instanceof IProject) {
                final IResourceDelta resourceDelta = delta.getResourceDelta();
                final IProject project = (IProject)delta.getResource();
                if ((resourceDelta.getFlags() & 0x4000) != 0) {
                    if (project.isOpen()) {
                        delta.setKind(Kind.ADDED);
                        this.mEventDispatcher.notify(delta.getKind(), delta);
                        AbstractResourceDelta removeProjectResourceDelta = new AbstractResourceDelta(){

                            public IResource getResource() {
                                return project;
                            }

                            public int getKind() {
                                return 2;
                            }

                            public IPath getFullPath() {
                                return resourceDelta.getFullPath();
                            }

                            public IPath getProjectRelativePath() {
                                return resourceDelta.getProjectRelativePath();
                            }

                            public IResourceDelta[] getAffectedChildren() {
                                return new IResourceDelta[0];
                            }
                        };
                        NlpModelDeltaImpl removeProjectDelta = new NlpModelDeltaImpl((NlpModelDeltaImpl)delta.getParent(), removeProjectResourceDelta);
                        NlpModelDeltaImpl parent = (NlpModelDeltaImpl)delta.getParent();
                        parent.addChild(removeProjectDelta);
                        return;
                    }
                    delta.setKind(Kind.REMOVED);
                    this.mEventDispatcher.notify(delta.getKind(), delta);
                    AbstractResourceDelta removeProjectResourceDelta = new AbstractResourceDelta(){

                        public IResource getResource() {
                            return project;
                        }

                        public int getKind() {
                            return 1;
                        }

                        public IPath getFullPath() {
                            return resourceDelta.getFullPath();
                        }

                        public IPath getProjectRelativePath() {
                            return resourceDelta.getProjectRelativePath();
                        }

                        public IResourceDelta[] getAffectedChildren() {
                            return new IResourceDelta[0];
                        }
                    };
                    NlpModelDeltaImpl removeProjectDelta = new NlpModelDeltaImpl((NlpModelDeltaImpl)delta.getParent(), removeProjectResourceDelta);
                    NlpModelDeltaImpl parent = (NlpModelDeltaImpl)delta.getParent();
                    parent.addChild(removeProjectDelta);
                    return;
                }
                if ((resourceDelta.getFlags() & 0x80000) != 0 && project.isOpen()) {
                    AbstractResourceDelta removeProjectResourceDelta = new AbstractResourceDelta(){

                        public IResource getResource() {
                            return project;
                        }

                        public int getKind() {
                            return 2;
                        }

                        public IPath getFullPath() {
                            return resourceDelta.getFullPath();
                        }

                        public IPath getProjectRelativePath() {
                            return resourceDelta.getProjectRelativePath();
                        }

                        public IResourceDelta[] getAffectedChildren() {
                            return new IResourceDelta[0];
                        }
                    };
                    NlpModelDeltaImpl removeProjectDelta = new NlpModelDeltaImpl((NlpModelDeltaImpl)delta.getParent(), removeProjectResourceDelta);
                    NlpModelDeltaImpl parent = (NlpModelDeltaImpl)delta.getParent();
                    parent.addChild(removeProjectDelta);
                    delta.setKind(Kind.ADDED);
                    this.mEventDispatcher.notify(delta.getKind(), delta);
                }
            }
            delta.setNlpElement(CasEditorPlugin.getNlpModel().findMember(delta.getResource()));
            this.processChildEvents(delta);
            try {
                INlpElement parent = CasEditorPlugin.getNlpModel().getParent(delta.getResource());
                if (parent != null) {
                    CasEditorPlugin.getNlpModel().changeInternal(delta);
                }
            }
            catch (CoreException e) {
                CasEditorPlugin.log(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RemoveHandler
    extends AbstractEventHandler {
        RemoveHandler(EventDispatcher<Kind, NlpModelDeltaImpl> handler) {
            super(handler);
        }

        @Override
        public void handle(NlpModelDeltaImpl delta) {
            INlpElement parent;
            delta.setNlpElement(CasEditorPlugin.getNlpModel().findMember(delta.getResource()));
            this.processChildEvents(delta);
            if (delta.isNlpElement() && (parent = delta.getNlpElement().getParent()) != null) {
                CasEditorPlugin.getNlpModel().removeInternal(delta, delta.getResource());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddHandler
    extends AbstractEventHandler {
        protected AddHandler(EventDispatcher<Kind, NlpModelDeltaImpl> handler) {
            super(handler);
        }

        @Override
        public void handle(NlpModelDeltaImpl delta) {
            CasEditorPlugin.getNlpModel().addInternal(delta, delta.getResource());
            delta.setNlpElement(CasEditorPlugin.getNlpModel().findMember(delta.getResource()));
            this.processChildEvents(delta);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultEventHandler
    implements IEventHandler<NlpModelDeltaImpl> {
        private DefaultEventHandler() {
        }

        @Override
        public void handle(NlpModelDeltaImpl delta) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractEventHandler
    implements IEventHandler<NlpModelDeltaImpl> {
        protected EventDispatcher<Kind, NlpModelDeltaImpl> mEventDispatcher;

        AbstractEventHandler(EventDispatcher<Kind, NlpModelDeltaImpl> handler) {
            this.mEventDispatcher = handler;
        }

        protected void processChildEvents(INlpElementDelta delta) {
            INlpElementDelta[] childDeltas;
            for (INlpElementDelta childDelta : childDeltas = delta.getAffectedChildren()) {
                this.mEventDispatcher.notify(childDelta.getKind(), (NlpModelDeltaImpl)childDelta);
            }
        }
    }

    private final class ResourceChangeListener
    implements IResourceChangeListener {
        EventDispatcher<Kind, NlpModelDeltaImpl> mEventDispatcher = new EventDispatcher(new DefaultEventHandler());

        ResourceChangeListener() {
            this.mEventDispatcher.register(Kind.ADDED, new AddHandler(this.mEventDispatcher));
            this.mEventDispatcher.register(Kind.REMOVED, new RemoveHandler(this.mEventDispatcher));
            this.mEventDispatcher.register(Kind.CHANGED, new ChangedHandler(this.mEventDispatcher));
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() != 1 || event.getResource() instanceof IWorkspaceRoot) {
                return;
            }
            IResourceDelta rootDelta = event.getDelta();
            NlpModelDeltaImpl modelDelta = new NlpModelDeltaImpl(null, rootDelta);
            this.mEventDispatcher.notify(modelDelta.getKind(), modelDelta);
            for (NlpProject project : NlpModel.this.mNlpProjects) {
                try {
                    project.postProcessResourceChanges();
                }
                catch (CoreException e) {
                    NlpModel.this.handleExceptionDuringResoruceChange(e);
                }
            }
            for (INlpModelChangeListener modelListener : NlpModel.this.mModelChangeListeners) {
                modelListener.resourceChanged(modelDelta);
            }
        }
    }
}

