/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.uima.cas.Type;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.core.model.AbstractNlpElement;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.NlpModel;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.model.delta.INlpElementDelta;
import org.apache.uima.caseditor.core.model.dotcorpus.DotCorpus;
import org.apache.uima.caseditor.core.model.dotcorpus.DotCorpusSerializer;
import org.apache.uima.caseditor.core.util.MarkerUtil;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotCorpusElement
extends AbstractNlpElement {
    private DotCorpus mDotCorpus;
    private IFile mResource;
    private NlpProject mNlpProject;

    private DotCorpusElement(IFile resource, NlpProject nlpProject) {
        this.mResource = resource;
        this.mNlpProject = nlpProject;
        this.mDotCorpus = new DotCorpus();
    }

    public IFile getTypeSystemFile() {
        IFile result = this.mDotCorpus.getTypeSystemFileName() != null ? this.getFile(this.mDotCorpus.getTypeSystemFileName()) : null;
        return result;
    }

    public boolean isTypeSystemFile(IFile file) {
        return this.getTypeSystemFile().equals(file);
    }

    public void setTypeSystemFilename(String filename) {
        this.mDotCorpus.setTypeSystemFilename(filename);
    }

    public Collection<IFolder> getCorpusFolderNameList() {
        LinkedList<IFolder> corpusFolders = new LinkedList<IFolder>();
        for (String corpusFolderString : this.mDotCorpus.getCorpusFolderNameList()) {
            corpusFolders.add(this.getFolder(corpusFolderString));
        }
        return Collections.unmodifiableCollection(corpusFolders);
    }

    public void addCorpusFolder(String name) {
        this.mDotCorpus.addCorpusFolder(name);
    }

    public void removeCorpusFolder(IFolder folder) {
        this.mDotCorpus.removeCorpusFolder(folder.getName());
    }

    public boolean isCorpusFolder(IFolder folder) {
        boolean result = false;
        for (IFolder candidate : this.getCorpusFolderNameList()) {
            if (!candidate.equals(folder)) continue;
            result = true;
            break;
        }
        return result;
    }

    Collection<AnnotationStyle> getAnnotationStyles() {
        return this.mDotCorpus.getAnnotationStyles();
    }

    public void setStyle(AnnotationStyle style) {
        this.mDotCorpus.setStyle(style);
    }

    public void removeStyle(String name) {
        this.mDotCorpus.removeStyle(name);
    }

    public AnnotationStyle getAnnotation(Type type) {
        return this.mDotCorpus.getAnnotation(type);
    }

    public Collection<String> getShownTypes() {
        return this.mDotCorpus.getShownTypes();
    }

    public void removeShownType(String type) {
        this.mDotCorpus.removeShownType(type);
    }

    public void addShownType(String type) {
        this.mDotCorpus.setShownType(type);
    }

    public Collection<IFolder> getCasProcessorFolders() {
        LinkedList<IFolder> casProcessorFolders = new LinkedList<IFolder>();
        for (String corpusFolderString : this.mDotCorpus.getCasProcessorFolderNames()) {
            casProcessorFolders.add(this.getFolder(corpusFolderString));
        }
        return Collections.unmodifiableCollection(casProcessorFolders);
    }

    public boolean isCasProcessorFolder(IFolder folder) {
        boolean result = false;
        for (IFolder candidate : this.getCasProcessorFolders()) {
            if (!candidate.equals(folder)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void addCasProcessorFolder(String folder) {
        this.mDotCorpus.addCasProcessorFolder(folder);
    }

    public void removeCasProcessorFolder(String name) {
        this.mDotCorpus.removeCasProcessorFolder(name);
    }

    private IFile getFile(String name) {
        IProject project = (IProject)this.getNlpProject().getResource();
        return project.getFile(name);
    }

    private IFolder getFolder(String name) {
        IProject project = (IProject)this.getNlpProject().getResource();
        return project.getFolder(name);
    }

    public int getEditorLineLengthHint() {
        return this.mDotCorpus.getEditorLineLengthHint();
    }

    public void setEditorLineLengthHint(int lineLengthHint) {
        this.mDotCorpus.setEditorLineLength(lineLengthHint);
    }

    public void serialize() throws CoreException {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        DotCorpusSerializer.serialize(this.mDotCorpus, outBuffer);
        if (this.mResource.exists()) {
            this.mResource.setContents((InputStream)new ByteArrayInputStream(outBuffer.toByteArray()), true, true, null);
        } else {
            this.mResource.create((InputStream)new ByteArrayInputStream(outBuffer.toByteArray()), true, null);
        }
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean result;
        if (this == object) {
            result = true;
        } else if (object instanceof DotCorpusElement) {
            DotCorpusElement element = (DotCorpusElement)object;
            result = this.mDotCorpus.equals(element.mDotCorpus) && this.mResource.equals(element.mResource) && this.mNlpProject.equals(element.mNlpProject);
        } else {
            result = false;
        }
        return result;
    }

    static DotCorpusElement createDotCorpus(final IFile file, NlpProject project) {
        DotCorpusElement dotCorpusElement = new DotCorpusElement(file, project);
        if (file.exists()) {
            Runnable clearMarkers = new Runnable(){

                public void run() {
                    try {
                        MarkerUtil.clearMarkers((IResource)file, "org.apache.uima.caseditor.problem");
                    }
                    catch (CoreException e) {
                        CasEditorPlugin.log(e);
                    }
                }
            };
            ((NlpModel)project.getParent()).asyncExcuteQueue(clearMarkers);
            try {
                dotCorpusElement.mDotCorpus = DotCorpusSerializer.parseDotCorpus(file.getContents());
            }
            catch (CoreException e) {
                Runnable createMarker = new Runnable(){

                    public void run() {
                        try {
                            MarkerUtil.createMarker((IResource)file, e.getMessage());
                        }
                        catch (CoreException e2) {
                            CasEditorPlugin.log(e2);
                        }
                    }
                };
                ((NlpModel)project.getParent()).asyncExcuteQueue(createMarker);
            }
        }
        return dotCorpusElement;
    }

    @Override
    public INlpElement getParent() {
        return this.mNlpProject;
    }

    @Override
    public IResource getResource() {
        return this.mResource;
    }

    @Override
    public NlpProject getNlpProject() {
        return this.mNlpProject;
    }

    @Override
    public String getName() {
        return ".corpus";
    }

    @Override
    void addResource(INlpElementDelta delta, IResource resource) {
    }

    @Override
    void removeResource(INlpElementDelta delta, IResource resource) {
    }
}

