/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import org.apache.uima.cas.CAS;
import org.apache.uima.caseditor.core.model.AbstractNlpElement;
import org.apache.uima.caseditor.core.model.CorpusElement;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.model.delta.INlpElementDelta;
import org.apache.uima.caseditor.editor.DocumentFormat;
import org.apache.uima.caseditor.editor.DocumentUimaImpl;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class DocumentElement
extends AbstractNlpElement
implements IAdaptable {
    private CorpusElement mParent;
    private IFile mDocumentFile;
    private SoftReference<DocumentUimaImpl> mWorkingCopy = new SoftReference<Object>(null);
    private boolean isSavingWorkingCopy;

    DocumentElement(CorpusElement corpus, IFile documentFile) {
        if (corpus == null || documentFile == null) {
            throw new IllegalArgumentException("Parameters must not be null!");
        }
        this.mParent = corpus;
        this.mDocumentFile = documentFile;
    }

    public IFile getResource() {
        return this.mDocumentFile;
    }

    public String getName() {
        return this.mDocumentFile.getName();
    }

    public INlpElement getParent() {
        return this.mParent;
    }

    public ICasDocument getDocument(boolean reload) throws CoreException {
        NlpProject project = (NlpProject)this.mParent.getParent();
        if (project.getTypesystemElement() == null) {
            this.mWorkingCopy = null;
            throw new CoreException((IStatus)new Status(4, "org.apache.uima.caseditor", 0, "Typesystem not available!", null));
        }
        DocumentUimaImpl document = this.mWorkingCopy.get();
        if (reload || document == null) {
            DocumentFormat format;
            InputStream in = this.mDocumentFile.getContents();
            if (this.getResource().getFileExtension().equalsIgnoreCase("xcas")) {
                format = DocumentFormat.XCAS;
            } else if (this.getResource().getFileExtension().equalsIgnoreCase("xmi")) {
                format = DocumentFormat.XMI;
            } else {
                throw new CoreException((IStatus)new Status(4, "org.apache.uima.caseditor", 0, "Unkown file extension!", null));
            }
            CAS cas = project.getTypesystemElement().getCAS();
            document = new DocumentUimaImpl(cas, in, format);
            this.mWorkingCopy = new SoftReference<DocumentUimaImpl>(document);
        }
        return document;
    }

    public void saveDocument() throws CoreException {
        this.isSavingWorkingCopy = true;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(40000);
        ((DocumentUimaImpl)this.getDocument(false)).serialize(outStream);
        ByteArrayInputStream stream = new ByteArrayInputStream(outStream.toByteArray());
        this.mDocumentFile.setContents((InputStream)stream, true, false, null);
    }

    public NlpProject getNlpProject() {
        return (NlpProject)this.getParent().getParent();
    }

    void addResource(INlpElementDelta delta, IResource resource) {
    }

    void changedResource(IResource resource, INlpElementDelta delta) {
        if (!this.isSavingWorkingCopy) {
            this.mWorkingCopy = new SoftReference<Object>(null);
        } else {
            this.isSavingWorkingCopy = false;
        }
    }

    void removeResource(INlpElementDelta delta, IResource resource) {
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

