/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.core.model;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.caseditor.core.model.AbstractNlpElement;
import org.apache.uima.caseditor.core.model.DocumentElement;
import org.apache.uima.caseditor.core.model.INlpElement;
import org.apache.uima.caseditor.core.model.NlpProject;
import org.apache.uima.caseditor.core.model.delta.INlpElementDelta;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CorpusElement
extends AbstractNlpElement
implements INlpElement,
IAdaptable {
    private NlpProject mParentElement;
    private IFolder mCorpusFolder;
    private Collection<DocumentElement> mDocuments = new LinkedList<DocumentElement>();

    CorpusElement(NlpProject nlpProject, IFolder corpusFolder) {
        this.mParentElement = nlpProject;
        this.mCorpusFolder = corpusFolder;
    }

    void initialize() throws CoreException {
        this.createDocuments();
    }

    private IFolder getCorpusFolder() {
        return this.mCorpusFolder;
    }

    public boolean exists() {
        return this.getCorpusFolder() != null;
    }

    public Collection<DocumentElement> getDocuments() {
        return this.mDocuments;
    }

    private void createDocuments() throws CoreException {
        IResource[] resources;
        for (IResource resource : resources = this.getCorpusFolder().members()) {
            if (!(resource instanceof IFile)) continue;
            this.mDocuments.add(new DocumentElement(this, (IFile)resource));
        }
    }

    @Override
    public IResource getResource() {
        return this.getCorpusFolder();
    }

    @Override
    public INlpElement getParent() {
        return this.mParentElement;
    }

    @Override
    public INlpElement getParent(IResource resource) throws CoreException {
        INlpElement result = super.getParent(resource);
        if (result == null) {
            for (DocumentElement document : this.getDocuments()) {
                INlpElement element = document.getParent(resource);
                if (element == null) continue;
                result = element;
                break;
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this.getCorpusFolder().getName();
    }

    @Override
    public INlpElement findMember(IResource resource) {
        if (this.mCorpusFolder.equals(resource)) {
            return this;
        }
        if (!this.exists()) {
            return null;
        }
        Collection<DocumentElement> documents = this.getDocuments();
        for (DocumentElement document : documents) {
            boolean isElementFound = document.findMember(resource) != null;
            if (!isElementFound) continue;
            return document.findMember(resource);
        }
        return null;
    }

    @Override
    public NlpProject getNlpProject() {
        return (NlpProject)this.getParent();
    }

    @Override
    void addResource(INlpElementDelta delta, IResource resource) {
        if (resource instanceof IFile) {
            this.mDocuments.add(new DocumentElement(this, (IFile)resource));
        }
    }

    @Override
    void changedResource(IResource resource, INlpElementDelta delta) {
        for (DocumentElement document : this.getDocuments()) {
            if (!document.getResource().equals(resource)) continue;
            document.changedResource(resource, delta);
            break;
        }
    }

    @Override
    void removeResource(INlpElementDelta delta, IResource resource) {
        for (DocumentElement document : this.mDocuments) {
            if (!document.getResource().equals(resource)) continue;
            this.mDocuments.remove(document);
            break;
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj instanceof CorpusElement) {
            CorpusElement element = (CorpusElement)obj;
            result = this.getResource().equals(element.getResource());
        } else {
            result = false;
        }
        return result;
    }
}

